/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.operation;

import java.sql.SQLException;
import java.util.Map;
import org.mule.db.commons.shaded.AbstractDbConnector;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.db.commons.shaded.internal.domain.metadata.QuerySingleMetadataResolver;
import org.mule.db.commons.shaded.internal.domain.metadata.SelectMetadataResolver;
import org.mule.db.commons.shaded.internal.domain.metadata.StoredProcedureMetadataResolver;
import org.mule.db.commons.shaded.internal.operation.DmlOperations;
import org.mule.db.commons.shaded.internal.operation.OperationErrorTypeProvider;
import org.mule.extension.db.api.StatementResult;
import org.mule.extension.db.api.param.QueryDefinition;
import org.mule.extension.db.api.param.StoredProcedureCall;
import org.mule.extension.db.internal.domain.autogeneratedkey.DbAutoGenerateKeysAttributes;
import org.mule.extension.db.internal.util.MigrationUtils;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.extension.api.annotation.Streaming;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.runtime.operation.FlowListener;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

@Throws(value={OperationErrorTypeProvider.class})
public class DbDmlOperations
implements Initialisable {
    private DmlOperations dmlOperations;

    public void initialise() throws InitialisationException {
        this.dmlOperations = new DmlOperations.Builder().build();
    }

    @OutputResolver(output=SelectMetadataResolver.class)
    public PagingProvider<DbConnection, Map<String, Object>> select(@ParameterGroup(name="Query") @Placement(tab="Advanced") QueryDefinition query, @Config AbstractDbConnector connector, StreamingHelper streamingHelper, FlowListener flowListener) throws SQLException {
        return this.dmlOperations.select(MigrationUtils.mapQueryDefinition(query), connector, streamingHelper, flowListener);
    }

    @OutputResolver(output=QuerySingleMetadataResolver.class)
    public Map<String, Object> querySingle(@ParameterGroup(name="Query") @Placement(tab="Advanced") QueryDefinition query, @Config AbstractDbConnector connector, @Connection DbConnection connection, StreamingHelper streamingHelper) throws SQLException {
        return this.dmlOperations.querySingle(MigrationUtils.mapQueryDefinition(query), connector, connection, streamingHelper);
    }

    public StatementResult insert(@ParameterGroup(name="Query") @Placement(tab="Advanced") QueryDefinition query, @ParameterGroup(name="Auto Generate Keys") DbAutoGenerateKeysAttributes autoGenerateKeysAttributes, @Config AbstractDbConnector connector, @Connection DbConnection connection, StreamingHelper streamingHelper) throws SQLException {
        return new StatementResult(this.dmlOperations.insert(MigrationUtils.mapQueryDefinition(query), autoGenerateKeysAttributes, connector, connection, streamingHelper));
    }

    public StatementResult update(@ParameterGroup(name="Query") QueryDefinition query, @ParameterGroup(name="Auto Generate Keys") DbAutoGenerateKeysAttributes autoGenerateKeysAttributes, @Config AbstractDbConnector connector, @Connection DbConnection connection, StreamingHelper streamingHelper) throws SQLException {
        return new StatementResult(this.dmlOperations.update(MigrationUtils.mapQueryDefinition(query), autoGenerateKeysAttributes, connector, connection, streamingHelper));
    }

    public int delete(@ParameterGroup(name="Query") QueryDefinition query, @Config AbstractDbConnector connector, @Connection DbConnection connection, StreamingHelper streamingHelper) throws SQLException {
        return this.dmlOperations.delete(MigrationUtils.mapQueryDefinition(query), connector, connection, streamingHelper);
    }

    @Streaming
    @OutputResolver(output=StoredProcedureMetadataResolver.class)
    public Map<String, Object> storedProcedure(@ParameterGroup(name="Query") StoredProcedureCall call, @ParameterGroup(name="Auto Generate Keys") DbAutoGenerateKeysAttributes autoGenerateKeysAttributes, @Config AbstractDbConnector connector, @Connection DbConnection connection, StreamingHelper streamingHelper, FlowListener flowListener) throws SQLException {
        return this.dmlOperations.storedProcedure(MigrationUtils.mapStoredProcedureCall(call), autoGenerateKeysAttributes, connector, connection, streamingHelper, flowListener);
    }
}

