/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.operation;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.mule.db.commons.shaded.AbstractDbConnector;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.db.commons.shaded.internal.domain.metadata.DbInputMetadataResolver;
import org.mule.db.commons.shaded.internal.operation.BulkOperations;
import org.mule.db.commons.shaded.internal.operation.OperationErrorTypeProvider;
import org.mule.extension.db.api.param.BulkQueryDefinition;
import org.mule.extension.db.api.param.BulkScript;
import org.mule.extension.db.api.param.QuerySettings;
import org.mule.extension.db.internal.util.MigrationUtils;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

@Throws(value={OperationErrorTypeProvider.class})
public class DbBulkOperations
implements Initialisable {
    private BulkOperations bulkOperations;

    public void initialise() throws InitialisationException {
        this.bulkOperations = new BulkOperations.Builder().build();
    }

    public int[] bulkInsert(@DisplayName(value="Input Parameters") @Content @Placement(order=1) @TypeResolver(value=DbInputMetadataResolver.class) List<Map<String, Object>> bulkInputParameters, @ParameterGroup(name="Query") BulkQueryDefinition query, @Config AbstractDbConnector connector, @Connection DbConnection connection, StreamingHelper streamingHelper) throws SQLException {
        return this.bulkOperations.bulkInsert(bulkInputParameters, MigrationUtils.mapBulkQueryDefinition(query), connector, connection, streamingHelper);
    }

    public int[] bulkUpdate(@DisplayName(value="Input Parameters") @Content @Placement(order=1) @TypeResolver(value=DbInputMetadataResolver.class) List<Map<String, Object>> bulkInputParameters, @ParameterGroup(name="Query") BulkQueryDefinition query, @Config AbstractDbConnector connector, @Connection DbConnection connection, StreamingHelper streamingHelper) throws SQLException {
        return this.bulkOperations.bulkUpdate(bulkInputParameters, MigrationUtils.mapBulkQueryDefinition(query), connector, connection, streamingHelper);
    }

    public int[] bulkDelete(@DisplayName(value="Input Parameters") @Content @Placement(order=1) @TypeResolver(value=DbInputMetadataResolver.class) List<Map<String, Object>> bulkInputParameters, @ParameterGroup(name="Query") BulkQueryDefinition query, @Config AbstractDbConnector connector, @Connection DbConnection connection, StreamingHelper streamingHelper) throws SQLException {
        return this.bulkOperations.bulkDelete(bulkInputParameters, MigrationUtils.mapBulkQueryDefinition(query), connector, connection, streamingHelper);
    }

    public int[] executeScript(@ParameterGroup(name="Query") BulkScript script, @ParameterGroup(name="Query Settings") QuerySettings settings, @Connection DbConnection connection) throws SQLException {
        return this.bulkOperations.executeScript(MigrationUtils.mapBulkScript(script), MigrationUtils.mapQuerySettings(settings), connection);
    }
}

