/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.lifecycle;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Timer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.SimpleFormatter;
import java.util.stream.Stream;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.mule.extension.db.internal.lifecycle.DbArtifactLifecycleListenerCommons;
import org.mule.sdk.api.artifact.lifecycle.ArtifactDisposalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleArtifactLifecycleListener
extends DbArtifactLifecycleListenerCommons {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleArtifactLifecycleListener.class);
    private static final String[] DRIVER_NAMES = new String[]{"oracle.jdbc.OracleDriver"};
    public static final String DIAGNOSABILITY_BEAN_NAME = "diagnosability";
    private static final String AVOID_DISPOSE_TIMER_THREADS_PROPERTY_NAME = "mule.db.connector.oracle.avoid.dispose.threads";
    private static final boolean AVOID_DISPOSE_TIMER_THREADS = Boolean.getBoolean("mule.db.connector.oracle.avoid.dispose.threads");
    private static final String AVOID_REMOVE_LOGGER_FORMATTER_PROPERTY_NAME = "mule.db.connector.oracle.avoid.remove.logger.formatter";
    private static final boolean AVOID_REMOVE_LOGGER_FORMATTER = Boolean.getBoolean("mule.db.connector.oracle.avoid.remove.logger.formatter");

    @Override
    public void onArtifactDisposal(ArtifactDisposalContext artifactDisposalContext) {
        LOGGER.debug("Running onArtifactDisposal method on OracleArtifactLifecycleListener");
        this.deregisterDrivers(artifactDisposalContext);
    }

    @Override
    public String[] getDriverNames() {
        return DRIVER_NAMES;
    }

    @Override
    public Stream<Driver> getDriversStream() {
        return Collections.list(DriverManager.getDrivers()).stream();
    }

    @Override
    public void unregisterDriver(Driver driver) throws SQLException {
        DriverManager.deregisterDriver(driver);
    }

    @Override
    public void additionalCleaning(ArtifactDisposalContext disposalContext, Driver driver) {
        this.checkingVersionsWithLeaksKnownSolvedInNewerVersions(driver);
        if (!AVOID_REMOVE_LOGGER_FORMATTER) {
            this.removeOracleSimpleFormatter(disposalContext);
        }
        if (!AVOID_DISPOSE_TIMER_THREADS) {
            this.cleanClassloader(disposalContext.getArtifactClassLoader());
            this.cleanClassloader(disposalContext.getExtensionClassLoader());
        }
    }

    private void checkingVersionsWithLeaksKnownSolvedInNewerVersions(Driver driver) {
        int major = driver.getMajorVersion();
        int minor = driver.getMinorVersion();
        if (major < 19 || major == 19 && minor < 14) {
            LOGGER.warn("Oracle Driver prior to 19.4 have a known issue whereby Thread Leaks are generated. Consider upgrading to a newer version of the driver.");
        }
    }

    private void cleanClassloader(ClassLoader classloader) {
        this.deregisterOracleDiagnosabilityMBean(classloader);
        this.cancelTimerThreads(classloader);
    }

    private void deregisterOracleDiagnosabilityMBean(ClassLoader cl) {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Hashtable<String, String> keys = new Hashtable<String, String>();
        keys.put("type", DIAGNOSABILITY_BEAN_NAME);
        keys.put("name", cl.getClass().getName() + "@" + Integer.toHexString(cl.hashCode()).toLowerCase());
        try {
            mBeanServer.unregisterMBean(new ObjectName("com.oracle.jdbc", keys));
        }
        catch (InstanceNotFoundException e) {
            LOGGER.debug("No Oracle's MBean found.");
        }
        catch (Throwable e) {
            LOGGER.debug("Unable to unregister Oracle's MBeans");
        }
    }

    private void cancelTimerThreads(ClassLoader classLoader) {
        try {
            Class<?> diagnosticClass = Class.forName("oracle.jdbc.diagnostics.Diagnostic", true, classLoader);
            Field clockField = diagnosticClass.getDeclaredField("CLOCK");
            Boolean accessibility = clockField.isAccessible();
            clockField.setAccessible(true);
            Timer clockValue = (Timer)clockField.get(null);
            clockValue.cancel();
            clockField.setAccessible(accessibility);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            LOGGER.debug("Unable to cancel oracle.jdbc.diagnostics.Diagnostic.CLOCK Timer Thread");
        }
    }

    private void removeOracleSimpleFormatter(ArtifactDisposalContext disposalContext) {
        java.util.logging.Logger l;
        for (l = java.util.logging.Logger.getLogger("test"); l != null && l.getHandlers().length == 0; l = l.getParent()) {
        }
        Handler h = l == null ? null : l.getHandlers()[0];
        Formatter f = h.getFormatter();
        if (disposalContext.getExtensionClassLoader().equals(f.getClass().getClassLoader()) || disposalContext.getArtifactClassLoader().equals(f.getClass().getClassLoader())) {
            SimpleFormatter s = new SimpleFormatter();
            h.setFormatter(s);
        }
    }
}

