/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.lifecycle;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Stream;
import org.mule.extension.db.internal.lifecycle.DbArtifactLifecycleListenerCommons;
import org.mule.sdk.api.artifact.lifecycle.ArtifactDisposalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlArtifactLifecycleListener
extends DbArtifactLifecycleListenerCommons {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlArtifactLifecycleListener.class);
    private static final String[] DRIVER_NAMES = new String[]{"com.mysql.jdbc.Driver", "com.mysql.cj.jdbc.Driver"};
    private static final List<String> CONNECTION_CLEANUP_THREAD_KNOWN_CLASS_ADDRESES = Arrays.asList("com.mysql.jdbc.AbandonedConnectionCleanupThread", "com.mysql.cj.jdbc.AbandonedConnectionCleanupThread");
    private static final String AVOID_SHUTDOWN_CLEANUP_THREAD_PROPERTY_NAME = "mule.db.connector.mysql.avoid.shutdown.cleanup.thread";
    private static final boolean AVOID_SHUTDOWN_CLEANUP_THREAD = Boolean.getBoolean("mule.db.connector.mysql.avoid.shutdown.cleanup.thread");

    @Override
    public void onArtifactDisposal(ArtifactDisposalContext artifactDisposalContext) {
        LOGGER.debug("Running onArtifactDisposal method on MySqlArtifactLifecycleListener");
        this.deregisterDrivers(artifactDisposalContext);
    }

    @Override
    public String[] getDriverNames() {
        return DRIVER_NAMES;
    }

    @Override
    public Stream<Driver> getDriversStream() {
        return Collections.list(DriverManager.getDrivers()).stream();
    }

    @Override
    public void unregisterDriver(Driver driver) throws SQLException {
        DriverManager.deregisterDriver(driver);
    }

    @Override
    public void additionalCleaning(ArtifactDisposalContext disposalContext, Driver driver) {
        if (!AVOID_SHUTDOWN_CLEANUP_THREAD) {
            this.shutdownMySqlAbandonedConnectionCleanupThread(disposalContext);
        }
    }

    private void shutdownMySqlAbandonedConnectionCleanupThread(ArtifactDisposalContext artifactDisposalContext) {
        try {
            Class<?> cleanupThreadsClass = this.findMySqlCleanUpClass(artifactDisposalContext);
            this.shutdownMySqlConnectionCleanupThreads(cleanupThreadsClass);
            this.cleanMySqlCleanupThreadsThreadFactory(cleanupThreadsClass);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.debug("Failed an attempt to shutdown MySql's AbandonedConnectionCleanupThread");
        }
    }

    private void cleanMySqlCleanupThreadsThreadFactory(Class<?> cleanupThreadsClass) {
        try {
            Method checkedShutdown = cleanupThreadsClass.getMethod("checkedShutdown", null);
            checkedShutdown.invoke(null, new Object[0]);
            if (MySqlArtifactLifecycleListener.getJavaVersion().floatValue() <= 11.0f) {
                Field cleanupExecutorServiceField = cleanupThreadsClass.getDeclaredField("cleanupThreadExcecutorService");
                cleanupExecutorServiceField.setAccessible(true);
                ExecutorService delegateCleanupExecutorService = (ExecutorService)cleanupExecutorServiceField.get(cleanupThreadsClass);
                Field realExecutorServiceField = delegateCleanupExecutorService.getClass().getSuperclass().getDeclaredField("e");
                realExecutorServiceField.setAccessible(true);
                ThreadPoolExecutor realExecutorService = (ThreadPoolExecutor)realExecutorServiceField.get(delegateCleanupExecutorService);
                realExecutorService.setThreadFactory(Executors.defaultThreadFactory());
            }
            LOGGER.debug("MySql AbandonedConnectionCleanupThread shutdown.");
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.debug("Error cleaning threadFactory from AbandonedConnectionCleanupThread executor service");
        }
    }

    private void shutdownMySqlConnectionCleanupThreads(Class<?> classAbandonedConnectionCleanupThread) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            Method uncheckedShutdown = classAbandonedConnectionCleanupThread.getMethod("uncheckedShutdown", new Class[0]);
            uncheckedShutdown.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            Method checkedShutdown = classAbandonedConnectionCleanupThread.getMethod("shutdown", new Class[0]);
            checkedShutdown.invoke(null, new Object[0]);
        }
    }

    private Class<?> findMySqlCleanUpClass(ArtifactDisposalContext artifactDisposalContext) throws ClassNotFoundException {
        for (String knownCleanupThreadClassAddress : CONNECTION_CLEANUP_THREAD_KNOWN_CLASS_ADDRESES) {
            try {
                return Class.forName(knownCleanupThreadClassAddress, true, artifactDisposalContext.getExtensionClassLoader());
            }
            catch (ClassNotFoundException e) {
                LOGGER.debug("Trying to find an AbandonedConnectionCleanupThread registered");
            }
        }
        throw new ClassNotFoundException("No MySql's AbandonedConnectionCleanupThread class was found");
    }

    private static Float getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Float.valueOf(Float.parseFloat(version));
    }
}

