/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.lifecycle;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.stream.Stream;
import org.mule.extension.db.internal.lifecycle.DbArtifactLifecycleListenerCommons;
import org.mule.sdk.api.artifact.lifecycle.ArtifactDisposalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyArtifactLifecycleListener
extends DbArtifactLifecycleListenerCommons {
    private static final Logger LOGGER = LoggerFactory.getLogger(DerbyArtifactLifecycleListener.class);
    private static final String DRIVER_PACKAGE = "org.apache.derby.jdbc";
    private static final String[] DRIVER_NAMES = new String[]{"org.apache.derby.jdbc.EmbeddedDriver", "org.apache.derby.jdbc.AutoloadedDriver"};
    private static final String AVOID_SHUTDOWN_CONNECTION_PROPERTY_NAME = "mule.db.connector.derby.avoid.shutdown.connection";
    private static final boolean AVOID_SHUTDOWN_CONNECTION = Boolean.getBoolean("mule.db.connector.derby.avoid.shutdown.connection");

    @Override
    public void onArtifactDisposal(ArtifactDisposalContext artifactDisposalContext) {
        LOGGER.debug("Running onArtifactDisposal method on DerbyArtifactLifecycleListener");
        this.deregisterDrivers(artifactDisposalContext);
    }

    @Override
    public String[] getDriverNames() {
        return DRIVER_NAMES;
    }

    @Override
    public void additionalCleaning(ArtifactDisposalContext disposalContext, Driver driver) {
        if (this.isDriver(driver) && !AVOID_SHUTDOWN_CONNECTION) {
            this.leakPreventionForDerbyEmbeddedDriver(driver);
        }
    }

    @Override
    public Stream<Driver> getDriversStream() {
        return Collections.list(DriverManager.getDrivers()).stream();
    }

    @Override
    public void unregisterDriver(Driver driver) throws SQLException {
        DriverManager.deregisterDriver(driver);
    }

    private void leakPreventionForDerbyEmbeddedDriver(Driver driverObject) {
        try {
            driverObject.connect("jdbc:derby:;shutdown=true", null);
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("XJ015")) {
                LOGGER.debug("(XJ015): Derby system shutdown.");
            }
            LOGGER.debug("Unable to shutdown Derby's embedded driver on the DerbyArtifactLifecycleListener", (Throwable)e);
        }
    }
}

