/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.lifecycle;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.mule.extension.db.internal.lifecycle.DB2ArtifactLifecycleListener;
import org.mule.extension.db.internal.lifecycle.DbArtifactLifecycleListenerCommons;
import org.mule.extension.db.internal.lifecycle.DerbyArtifactLifecycleListener;
import org.mule.extension.db.internal.lifecycle.MySqlArtifactLifecycleListener;
import org.mule.extension.db.internal.lifecycle.OracleArtifactLifecycleListener;
import org.mule.sdk.api.artifact.lifecycle.ArtifactDisposalContext;
import org.mule.sdk.api.artifact.lifecycle.ArtifactLifecycleListener;

public class DbCompositeLifecycleListener
extends DbArtifactLifecycleListenerCommons {
    private static final String AVOID_ARTIFACT_DISPOSERS_PROPERTY_NAME = "mule.db.connector.avoid.all.artifact.disposers";
    private static final boolean AVOID_ARTIFACT_DISPOSERS = Boolean.getBoolean("mule.db.connector.avoid.all.artifact.disposers");
    private final List<ArtifactLifecycleListener> delegates = new ArrayList<ArtifactLifecycleListener>();

    public DbCompositeLifecycleListener() {
        this.delegates.add(new DerbyArtifactLifecycleListener());
        this.delegates.add(new OracleArtifactLifecycleListener());
        this.delegates.add(new MySqlArtifactLifecycleListener());
        this.delegates.add(new DB2ArtifactLifecycleListener());
    }

    @Override
    public void onArtifactDisposal(ArtifactDisposalContext disposalContext) {
        if (!AVOID_ARTIFACT_DISPOSERS) {
            this.delegates.forEach(x -> x.onArtifactDisposal(disposalContext));
            this.deregisterDrivers(disposalContext);
        }
    }

    @Override
    public Stream<Driver> getDriversStream() {
        return Collections.list(DriverManager.getDrivers()).stream();
    }

    @Override
    public void unregisterDriver(Driver driver) throws SQLException {
        DriverManager.deregisterDriver(driver);
    }

    @Override
    public boolean isDriver(Driver driver) {
        return Driver.class.isInstance(driver);
    }

    @Override
    public void additionalCleaning(ArtifactDisposalContext disposalContext, Driver driver) {
    }
}

