/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.lifecycle;

import java.beans.Introspector;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import org.mule.sdk.api.artifact.lifecycle.ArtifactDisposalContext;
import org.mule.sdk.api.artifact.lifecycle.ArtifactLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbArtifactLifecycleListenerCommons
implements ArtifactLifecycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbArtifactLifecycleListenerCommons.class);

    protected DbArtifactLifecycleListenerCommons() {
    }

    protected Stream<Driver> getDriversStream() {
        return Stream.empty();
    }

    protected void unregisterDriver(Driver driver) throws SQLException {
    }

    protected void deregisterDrivers(ArtifactDisposalContext disposalContext) {
        this.getDriversStream().filter(d -> disposalContext.isArtifactOwnedClassLoader(d.getClass().getClassLoader()) || disposalContext.isExtensionOwnedClassLoader(d.getClass().getClassLoader())).filter(this::isDriver).forEach(driver -> {
            try {
                this.unregisterDriver((Driver)driver);
                this.additionalCleaning(disposalContext, (Driver)driver);
            }
            catch (Exception e) {
                LOGGER.warn("Can not deregister driver. This can cause a memory leak.", (Throwable)e);
            }
        });
        this.cleanCaches(disposalContext);
    }

    protected boolean isDriver(Driver driver) {
        return Arrays.stream(this.getDriverNames()).anyMatch(name -> name.equals(driver.getClass().getName()));
    }

    protected void cleanCaches(ArtifactDisposalContext disposalContext) {
        Introspector.flushCaches();
        ResourceBundle.clearCache(disposalContext.getArtifactClassLoader());
        ResourceBundle.clearCache(disposalContext.getExtensionClassLoader());
    }

    protected void additionalCleaning(ArtifactDisposalContext disposalContext, Driver driver) {
    }

    protected String[] getDriverNames() {
        return new String[0];
    }

    public void onArtifactDisposal(ArtifactDisposalContext artifactDisposalContext) {
    }
}

