/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.lifecycle;

import java.lang.reflect.Field;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Timer;
import java.util.stream.Stream;
import org.mule.extension.db.internal.lifecycle.DbArtifactLifecycleListenerCommons;
import org.mule.sdk.api.artifact.lifecycle.ArtifactDisposalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DB2ArtifactLifecycleListener
extends DbArtifactLifecycleListenerCommons {
    private static final Logger LOGGER = LoggerFactory.getLogger(DB2ArtifactLifecycleListener.class);
    static final String[] DRIVER_NAMES = new String[]{"com.ibm.db2.jcc.DB2Driver"};
    private static final String AVOID_DISPOSE_TIMER_THREADS_PROPERTY_NAME = "mule.db.connector.db2.avoid.cancel.timer.thread";
    private static final boolean AVOID_DISPOSE_TIMER_THREADS = Boolean.getBoolean("mule.db.connector.db2.avoid.cancel.timer.thread");

    @Override
    public void onArtifactDisposal(ArtifactDisposalContext disposalContext) {
        LOGGER.debug("Running onArtifactDisposal method on DB2ArtifactLifecycleListener");
        this.deregisterDrivers(disposalContext);
        this.additionalCleaning(disposalContext, null);
    }

    @Override
    public void additionalCleaning(ArtifactDisposalContext disposalContext, Driver driver) {
        if (!AVOID_DISPOSE_TIMER_THREADS) {
            this.cancelTimerThreads(disposalContext.getExtensionOwnedThreads());
            this.cancelTimerThreads(disposalContext.getArtifactOwnedThreads());
        }
    }

    @Override
    public String[] getDriverNames() {
        return DRIVER_NAMES;
    }

    @Override
    public Stream<Driver> getDriversStream() {
        return Collections.list(DriverManager.getDrivers()).stream();
    }

    @Override
    public void unregisterDriver(Driver driver) throws SQLException {
        DriverManager.deregisterDriver(driver);
    }

    private void cancelTimerThreads(Stream<Thread> threadStream) {
        threadStream.filter(thread -> thread.getName().startsWith("Timer-")).forEach(thread -> {
            LOGGER.debug("DB2's Timer thread founded.");
            try {
                Class<?> diagnosticClass = Class.forName("com.ibm.db2.jcc.am.lg", true, thread.getContextClassLoader());
                Field clockField = diagnosticClass.getDeclaredField("a");
                Boolean accessibility = clockField.isAccessible();
                clockField.setAccessible(true);
                Timer clockValue = (Timer)clockField.get(null);
                clockValue.cancel();
                LOGGER.debug("Cancelling DB2's Timer Threads");
                clockField.setAccessible(accessibility);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                LOGGER.debug("Error attempting to cancel DB2's Timer Threads", (Throwable)e);
            }
        });
    }
}

