/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.logger;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.mule.extension.db.api.logger.MuleMySqlLogger;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;

public class MuleMySqlLoggerFactory {
    public static final String MYSQL_DRIVER_CLASS = "com.mysql.jdbc.Driver";
    public static final String NEW_MYSQL_DRIVER_CLASS = "com.mysql.cj.jdbc.Driver";
    private ClassLoader classLoader;
    private MuleMySqlLogger delegatedLogger;

    public MuleMySqlLoggerFactory(ClassLoader classLoader, MuleMySqlLogger delegatedLogger) {
        this.classLoader = classLoader;
        this.delegatedLogger = delegatedLogger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MuleMySqlLogger create() {
        Class<?> availableMySqlLogInterface = this.getAvailableMySqlLogInterface();
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition typeDefinition = new ByteBuddy().subclass(MuleMySqlLogger.class).implement(new Type[]{availableMySqlLogInterface}).method((ElementMatcher)ElementMatchers.isDeclaredBy(MuleMySqlLogger.class)).intercept((Implementation)MethodDelegation.to((Object)this.delegatedLogger));
        try (DynamicType.Unloaded dynamicType = typeDefinition.make();){
            MuleMySqlLogger muleMySqlLogger = (MuleMySqlLogger)dynamicType.load(this.classLoader, this.getClassLoadingStrategy()).getLoaded().getConstructor(String.class).newInstance("MySql");
            return muleMySqlLogger;
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not create instance of " + this.getClass().getName())), (Throwable)e);
        }
    }

    private ClassLoadingStrategy<? super ClassLoader> getClassLoadingStrategy() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ClassLoadingStrategy.Default strategy;
        if (ClassInjector.UsingLookup.isAvailable()) {
            Class<?> methodHandles = Class.forName("java.lang.invoke.MethodHandles");
            Object lookup = methodHandles.getMethod("lookup", new Class[0]).invoke(null, new Object[0]);
            Method privateLookupIn = methodHandles.getMethod("privateLookupIn", Class.class, Class.forName("java.lang.invoke.MethodHandles$Lookup"));
            Object privateLookup = privateLookupIn.invoke(null, MuleMySqlLogger.class, lookup);
            strategy = ClassLoadingStrategy.UsingLookup.of((Object)privateLookup);
        } else if (ClassInjector.UsingReflection.isAvailable()) {
            strategy = ClassLoadingStrategy.Default.INJECTION;
        } else {
            throw new IllegalStateException("No code generation strategy available");
        }
        return strategy;
    }

    private Class<?> getAvailableMySqlLogInterface() {
        try {
            return this.classLoader.loadClass("com.mysql.cj.log.Log");
        }
        catch (ClassNotFoundException e) {
            try {
                return this.classLoader.loadClass("com.mysql.jdbc.log.Log");
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Neither class, com.mysql.cj.log.Log or com.mysql.jdbc.log.Log, were found. An unsupported driver was provided.", ex);
            }
        }
    }
}

