/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.connection.sqlserver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;
import org.mule.db.commons.shaded.api.exception.connection.DbError;
import org.mule.db.commons.shaded.internal.domain.connection.DataSourceConfig;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnectionProvider;
import org.mule.extension.db.internal.domain.connection.sqlserver.SqlServerConnection;
import org.mule.extension.db.internal.domain.connection.sqlserver.SqlServerConnectionParameters;
import org.mule.extension.db.internal.util.MigrationUtils;
import org.mule.runtime.api.meta.ExternalLibraryType;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;

@DisplayName(value="Microsoft SQL Server Connection")
@Alias(value="mssql")
@ExternalLib(name="Microsoft SQL Server Driver", description="A JDBC driver which supports connecting to an Microsoft SQL Server Database", requiredClassName="com.microsoft.sqlserver.jdbc.SQLServerDriver", type=ExternalLibraryType.JAR, coordinates="com.microsoft.sqlserver:mssql-jdbc:7.0.0.jre8", nameRegexpMatcher="(.*)\\.jar")
public class SqlServerConnectionProvider
extends DbConnectionProvider {
    static final String DRIVER_CLASS_NAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    static final String MSSQL_GAV = "com.microsoft.sqlserver:mssql-jdbc:7.0.0.jre8";
    @ParameterGroup(name="Connection")
    private SqlServerConnectionParameters connectionParameters;

    @Override
    protected DbConnection createDbConnection(Connection connection) throws Exception {
        return new SqlServerConnection(connection, super.resolveCustomTypes(), this.cachedTemplates);
    }

    @Override
    public Optional<DataSource> getDataSource() {
        return Optional.empty();
    }

    @Override
    public Optional<DataSourceConfig> getDataSourceConfig() {
        return Optional.ofNullable(MigrationUtils.mapDataSourceConfig(this.connectionParameters));
    }

    @Override
    protected Optional<DbError> getDbVendorErrorType(SQLException e) {
        String message = e.getMessage();
        if (message.contains("Login failed for user")) {
            return Optional.of(DbError.INVALID_CREDENTIALS);
        }
        if (message.contains("Cannot open database")) {
            return Optional.of(DbError.INVALID_DATABASE);
        }
        if (message.contains("invalidHost")) {
            return Optional.of(DbError.CANNOT_REACH);
        }
        return Optional.empty();
    }
}

