/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.connection.sqlserver;

import java.util.HashMap;
import java.util.Map;
import org.mule.extension.db.internal.domain.connection.BaseDbConnectionParameters;
import org.mule.extension.db.internal.domain.connection.DataSourceConfig;
import org.mule.extension.db.internal.util.ExcludeFromGeneratedCoverage;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

public class SqlServerConnectionParameters
extends BaseDbConnectionParameters
implements DataSourceConfig {
    private static final String SUB_PROTOCOL = "jdbc:sqlserver://";
    @Parameter
    @Placement(order=1)
    private String host;
    @Parameter
    @Optional
    @Placement(order=2)
    private String instanceName;
    @Parameter
    @Optional
    @Placement(order=3)
    private Integer port;
    @Parameter
    @Optional
    @Placement(order=4)
    private String user;
    @Parameter
    @Optional
    @Placement(order=5)
    @Password
    private String password;
    @Parameter
    @Optional
    @Placement(order=6)
    private String databaseName;
    @Parameter
    @Optional
    @Placement(tab="Advanced")
    @NullSafe
    private Map<String, String> connectionProperties = new HashMap<String, String>();

    @Override
    public String getUrl() {
        return SUB_PROTOCOL + this.host + this.getInstanceNameUrlPart() + this.getPortUrlPart() + this.getProperties();
    }

    private String getInstanceNameUrlPart() {
        if (this.instanceName != null) {
            return "\\" + this.instanceName;
        }
        return "";
    }

    private String getPortUrlPart() {
        if (this.port != null) {
            return ":" + this.port;
        }
        return "";
    }

    private String getProperties() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.databaseName != null) {
            stringBuilder.append(";databaseName=");
            stringBuilder.append(this.databaseName);
        }
        this.connectionProperties.forEach((key, value) -> {
            stringBuilder.append(";");
            stringBuilder.append((String)key);
            stringBuilder.append("=");
            stringBuilder.append((String)value);
        });
        return stringBuilder.toString();
    }

    @Override
    public String getDriverClassName() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @ExcludeFromGeneratedCoverage
    public static String getSubProtocol() {
        return SUB_PROTOCOL;
    }

    @ExcludeFromGeneratedCoverage
    public String getHost() {
        return this.host;
    }

    @ExcludeFromGeneratedCoverage
    public void setHost(String host) {
        this.host = host;
    }

    @ExcludeFromGeneratedCoverage
    public String getInstanceName() {
        return this.instanceName;
    }

    @ExcludeFromGeneratedCoverage
    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    @ExcludeFromGeneratedCoverage
    public Integer getPort() {
        return this.port;
    }

    @ExcludeFromGeneratedCoverage
    public void setPort(Integer port) {
        this.port = port;
    }

    @ExcludeFromGeneratedCoverage
    public void setUser(String user) {
        this.user = user;
    }

    @ExcludeFromGeneratedCoverage
    public void setPassword(String password) {
        this.password = password;
    }

    @ExcludeFromGeneratedCoverage
    public String getDatabaseName() {
        return this.databaseName;
    }

    @ExcludeFromGeneratedCoverage
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @ExcludeFromGeneratedCoverage
    public Map<String, String> getConnectionProperties() {
        return this.connectionProperties;
    }

    @ExcludeFromGeneratedCoverage
    public void setConnectionProperties(Map<String, String> connectionProperties) {
        this.connectionProperties = connectionProperties;
    }
}

