/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.connection.oracle.util;

import java.util.Objects;

public final class OracleTNSEntryURLBuilder {
    private String protocol;
    private String host;
    private Integer port;
    private String instanceName;
    private String serviceName;

    public OracleTNSEntryURLBuilder withProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public OracleTNSEntryURLBuilder withHost(String host) {
        this.host = host;
        return this;
    }

    public OracleTNSEntryURLBuilder withPort(Integer port) {
        this.port = port;
        return this;
    }

    public OracleTNSEntryURLBuilder withInstanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    public OracleTNSEntryURLBuilder withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public String build() {
        Objects.requireNonNull(this.protocol, "Protocol can't be null");
        Objects.requireNonNull(this.host, "Host can't be null");
        Objects.requireNonNull(this.port, "Port can't be null");
        StringBuilder buf = new StringBuilder();
        buf.append("(DESCRIPTION=");
        buf.append("(ADDRESS=");
        buf.append("(PROTOCOL=").append(this.protocol).append(")");
        buf.append("(PORT=").append(this.port).append(")");
        buf.append("(HOST=").append(this.host).append(")");
        buf.append(")");
        buf.append("(CONNECT_DATA=");
        if (this.instanceName != null) {
            buf.append("(INSTANCE_NAME=").append(this.instanceName).append(")");
        }
        if (this.serviceName != null) {
            buf.append("(SERVICE_NAME=").append(this.serviceName).append(")");
        }
        buf.append(")");
        return buf.append(")").toString();
    }
}

