/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.connection.oracle.util;

import java.util.regex.Pattern;
import org.mule.db.commons.shaded.internal.util.CredentialsMaskUtils;
import org.mule.extension.db.internal.util.ExcludeFromGeneratedCoverage;

@ExcludeFromGeneratedCoverage
public class OracleCredentialsMaskUtils
extends CredentialsMaskUtils {
    public static final Pattern ORACLE_USER = Pattern.compile("jdbc:oracle:.*:(.*)/.*@");
    public static final Pattern ORACLE_PASSWORD = Pattern.compile("jdbc:oracle:.*:.*/(.*)@");

    public static String maskUrlUserAndPasswordForOracle(String input) {
        String oracleInputMasked = CredentialsMaskUtils.maskUrlUserAndPassword(input);
        oracleInputMasked = CredentialsMaskUtils.maskUrlPattern(oracleInputMasked, ORACLE_PASSWORD, "<<credentials>>", "password=");
        oracleInputMasked = CredentialsMaskUtils.maskUrlPattern(oracleInputMasked, ORACLE_USER, "<<user>>", "password=");
        return oracleInputMasked;
    }
}

