/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.connection.oracle.types;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.lang3.ClassUtils;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.db.commons.shaded.internal.domain.type.AbstractStructuredDbType;
import org.mule.extension.db.internal.util.ExcludeFromGeneratedCoverage;

@ExcludeFromGeneratedCoverage
public class OracleXmlTypeHandler
extends AbstractStructuredDbType {
    private static final String XML_TYPE_INTERNAL_NAME = "SYS.XMLTYPE";
    public static final String ORACLE_XMLTYPE_CLASS = "oracle.xdb.XMLType";

    public OracleXmlTypeHandler(int id, String name) {
        super(id, name);
    }

    @Override
    public Object getParameterValue(CallableStatement statement, int index) throws SQLException {
        return statement.getSQLXML(index);
    }

    @Override
    public void setParameterValue(PreparedStatement statement, int index, Object value, DbConnection connection) throws SQLException {
        try {
            if (value instanceof String) {
                statement.setObject(index, OracleXmlTypeHandler.createXmlType(statement.getConnection(), (String)value), this.getId());
                return;
            }
            if (value instanceof InputStream) {
                statement.setObject(index, OracleXmlTypeHandler.createXmlType(statement.getConnection(), (InputStream)value), this.getId());
                return;
            }
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        super.setParameterValue(statement, index, value, connection);
    }

    public static Object createXmlType(Connection connection, String xml) throws Exception {
        return OracleXmlTypeHandler.createXmlType(connection, xml, String.class);
    }

    public static Object createXmlType(Connection connection, InputStream xml) throws Exception {
        return OracleXmlTypeHandler.createXmlType(connection, xml, InputStream.class);
    }

    private static <T> Object createXmlType(Connection connection, T xmlContent, Class<T> tClass) throws Exception {
        Class<?> xmlTypeClass = OracleXmlTypeHandler.getXmlTypeClass();
        Constructor<?> xmlTypeConstructor = xmlTypeClass.getConstructor(Connection.class, tClass);
        return xmlTypeConstructor.newInstance(connection, xmlContent);
    }

    public static Class<?> getXmlTypeClass() throws ClassNotFoundException {
        return ClassUtils.getClass((String)ORACLE_XMLTYPE_CLASS);
    }
}

