/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.connection.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.mule.db.commons.shaded.api.exception.connection.DbError;
import org.mule.db.commons.shaded.internal.domain.connection.DataSourceConfig;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnectionProvider;
import org.mule.db.commons.shaded.internal.domain.type.ResolvedDbType;
import org.mule.extension.db.internal.domain.connection.oracle.OracleConnectionParameters;
import org.mule.extension.db.internal.domain.connection.oracle.OracleDbConnection;
import org.mule.extension.db.internal.util.ExcludeFromGeneratedCoverage;
import org.mule.extension.db.internal.util.MigrationUtils;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExternalLibraryType;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;

@DisplayName(value="Oracle Connection")
@Alias(value="oracle")
@ExternalLib(name="Oracle JDBC Driver", description="A JDBC driver which supports connecting to an Oracle Database", nameRegexpMatcher="(.*)\\.jar", requiredClassName="oracle.jdbc.driver.OracleDriver", type=ExternalLibraryType.JAR)
public class OracleDbConnectionProvider
extends DbConnectionProvider {
    private static final String INVALID_CREDENTIALS_ORACLE_CODE = "ORA-01017";
    private static final String UNKNOWN_SID_ORACLE_CODE = "ORA-12505";
    private static final String UNKNOWN_SERVICE_ORACLE_CODE = "ORA-12514";
    private static final String UNKNOWN_HOST_ORACLE_CODE = "ORA-17868";
    private static final String IO_ERROR = "IO Error: The Network Adapter could not establish the connection";
    @ParameterGroup(name="Connection")
    private OracleConnectionParameters oracleConnectionParameters;
    Map<String, Map<Integer, ResolvedDbType>> resolvedDbTypesCache = new ConcurrentHashMap<String, Map<Integer, ResolvedDbType>>();
    private final ConcurrentHashMap<String, String> resolvedDbTypeNamesCache = new ConcurrentHashMap();

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        LifecycleUtils.initialiseIfNeeded(this.oracleConnectionParameters.getTlsContextFactory());
    }

    @Override
    public Optional<DataSource> getDataSource() {
        return Optional.empty();
    }

    @Override
    public Optional<DataSourceConfig> getDataSourceConfig() {
        return Optional.ofNullable(MigrationUtils.mapDataSourceConfig(this.oracleConnectionParameters));
    }

    @Override
    protected DbConnection createDbConnection(Connection connection) throws Exception {
        return new OracleDbConnection(connection, super.resolveCustomTypes(), this.resolvedDbTypesCache, this.cachedTemplates, this.resolvedDbTypeNamesCache);
    }

    @Override
    public Optional<DbError> getDbVendorErrorType(SQLException e) {
        String message = e.getMessage();
        if (message.contains(INVALID_CREDENTIALS_ORACLE_CODE)) {
            return Optional.of(DbError.INVALID_CREDENTIALS);
        }
        if (message.contains(UNKNOWN_SID_ORACLE_CODE) || message.contains(UNKNOWN_SERVICE_ORACLE_CODE)) {
            return Optional.of(DbError.INVALID_DATABASE);
        }
        if (message.contains(IO_ERROR) || message.contains(UNKNOWN_HOST_ORACLE_CODE)) {
            return Optional.of(DbError.CANNOT_REACH);
        }
        return Optional.empty();
    }

    @ExcludeFromGeneratedCoverage
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof OracleDbConnectionProvider)) {
            return false;
        }
        OracleDbConnectionProvider that = (OracleDbConnectionProvider)o;
        return Objects.equals(this.oracleConnectionParameters, that.oracleConnectionParameters) && Objects.equals(this.resolvedDbTypesCache, that.resolvedDbTypesCache);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.oracleConnectionParameters, this.resolvedDbTypesCache);
    }
}

