/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.connection.oracle;

import com.github.benmanes.caffeine.cache.Cache;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import oracle.jdbc.OracleConnection;
import org.apache.commons.lang3.StringUtils;
import org.mule.db.commons.shaded.internal.domain.connection.DefaultDbConnection;
import org.mule.db.commons.shaded.internal.domain.connection.type.resolver.ArrayTypeResolver;
import org.mule.db.commons.shaded.internal.domain.connection.type.resolver.StructAndArrayTypeResolver;
import org.mule.db.commons.shaded.internal.domain.query.QueryTemplate;
import org.mule.db.commons.shaded.internal.domain.type.ArrayResolvedDbType;
import org.mule.db.commons.shaded.internal.domain.type.DbType;
import org.mule.db.commons.shaded.internal.domain.type.ResolvedDbType;
import org.mule.extension.db.internal.domain.connection.oracle.OracleConnectionUtils;
import org.mule.extension.db.internal.domain.connection.oracle.types.OracleOlderXMLType;
import org.mule.extension.db.internal.domain.connection.oracle.types.OracleOpaqueXMLType;
import org.mule.extension.db.internal.domain.connection.oracle.types.OracleSQLXMLType;
import org.mule.extension.db.internal.domain.connection.oracle.types.OracleSYSXMLType;
import org.mule.extension.db.internal.domain.connection.oracle.types.OracleXMLType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDbConnection
extends DefaultDbConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleDbConnection.class);
    public static final String TABLE_TYPE_NAME = "TABLE";
    private static final int CURSOR_TYPE_ID = -10;
    private static final String CURSOR_TYPE_NAME = "CURSOR";
    public static final String ATTR_TYPE_NAME_PARAM = "ATTR_TYPE_NAME";
    private static final String ATTR_NO_PARAM = "ATTR_NO";
    public static final String QUERY_TYPE_ATTRS = "SELECT ATTR_NO, ATTR_TYPE_NAME FROM ALL_TYPE_ATTRS WHERE TYPE_NAME = ? AND ATTR_TYPE_NAME IN ('CLOB', 'BLOB')";
    public static final String QUERY_PKG_ATTRS = "SELECT ATTR_NO, ATTR_TYPE_NAME FROM ALL_PLSQL_TYPE_ATTRS WHERE PACKAGE_NAME = ? AND ATTR_TYPE_NAME IN ('CLOB', 'BLOB')";
    private static final String QUERY_OWNER_CONDITION = " AND OWNER = ?";
    private static final int PROCEDURE_SCHEM_COLUMN_INDEX = 2;
    private static final int PROCEDURE_NAME = 3;
    private static final int PARAM_NAME_COLUMN_INDEX = 4;
    private final Map<String, Map<Integer, ResolvedDbType>> resolvedDbTypesCache;
    private final ConcurrentHashMap<String, String> resolvedDbTypeNamesCache;

    public OracleDbConnection(Connection jdbcConnection, List<DbType> customDataTypes, Map<String, Map<Integer, ResolvedDbType>> resolvedDbTypesCache, Cache<String, QueryTemplate> cachedTemplates, ConcurrentHashMap<String, String> resolvedDbTypeNamesCache) {
        super(jdbcConnection, customDataTypes, cachedTemplates);
        this.resolvedDbTypesCache = resolvedDbTypesCache;
        this.resolvedDbTypeNamesCache = resolvedDbTypeNamesCache;
    }

    @Override
    public List<DbType> getVendorDataTypes() {
        ArrayList<DbType> dbTypes = new ArrayList<DbType>();
        dbTypes.add(new ResolvedDbType(-10, CURSOR_TYPE_NAME));
        dbTypes.add(new OracleOpaqueXMLType());
        dbTypes.add(new OracleSQLXMLType());
        dbTypes.add(new OracleXMLType());
        dbTypes.add(new OracleOlderXMLType());
        dbTypes.add(new OracleSYSXMLType());
        return dbTypes;
    }

    @Override
    public Optional<String> getProcedureColumnType(String procedureName, String columnName, String owner) throws SQLException {
        try (PreparedStatement statement = this.getJdbcConnection().prepareStatement("SELECT TYPE_NAME FROM SYS.ALL_ARGUMENTS \nWHERE OWNER= ? \nAND OBJECT_NAME= ?\nAND ARGUMENT_NAME = ?\nORDER BY SEQUENCE");){
            statement.setString(1, owner);
            statement.setString(2, procedureName);
            statement.setString(3, columnName);
            ResultSet resultSet = statement.executeQuery();
            Optional<String> columnType = Optional.empty();
            if (resultSet.next()) {
                columnType = Optional.ofNullable(resultSet.getString(1));
            }
            Optional<String> optional = columnType;
            return optional;
        }
    }

    @Override
    public Set<String> getTables() throws SQLException {
        try (Statement statement = this.getJdbcConnection().createStatement();){
            statement.execute("SELECT table_name FROM user_tables");
            ResultSet resultSet = statement.getResultSet();
            HashSet<String> tables = new HashSet<String>();
            while (resultSet.next()) {
                tables.add(resultSet.getString(1));
            }
            HashSet<String> hashSet = tables;
            return hashSet;
        }
    }

    @Override
    public Array createArray(String typeName, Object[] values) throws SQLException {
        OracleConnection oracleConnection = this.getJdbcConnection().unwrap(OracleConnection.class);
        if (oracleConnection == null) {
            throw new RuntimeException("Can't reach Oracle extensions. Connection class was: " + this.getJdbcConnection().getClass().getName());
        }
        this.resolveLobs(typeName, values, new ArrayTypeResolver(this));
        values = Arrays.stream(values).map(e -> {
            if (e instanceof Collection) {
                return ((Collection)e).toArray();
            }
            return e;
        }).toArray();
        return oracleConnection.createARRAY(typeName, (Object)values);
    }

    @Override
    protected void resolveLobs(String typeName, Object[] attributes, StructAndArrayTypeResolver typeResolver) throws SQLException {
        Map<Integer, ResolvedDbType> dataTypes = this.getLobFieldsDataTypeInfo(typeResolver.resolveType(typeName, this.resolvedDbTypeNamesCache));
        for (Map.Entry<Integer, ResolvedDbType> entry : dataTypes.entrySet()) {
            int index = entry.getKey();
            ResolvedDbType dataType = entry.getValue();
            typeResolver.resolveLobs(attributes, index - 1, dataType.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<Integer, ResolvedDbType> getLobFieldsDataTypeInfo(String typeName) throws SQLException {
        if (this.resolvedDbTypesCache.containsKey(typeName)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Returning chached LobFieldsDataTypeInfo");
            }
            return this.resolvedDbTypesCache.get(typeName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Obtaining LobFieldsDataTypeInfo");
        }
        Map<String, Map<Integer, ResolvedDbType>> map = this.resolvedDbTypesCache;
        synchronized (map) {
            if (this.resolvedDbTypesCache.containsKey(typeName)) {
                return this.resolvedDbTypesCache.get(typeName);
            }
            HashMap<Integer, ResolvedDbType> dataTypes = new HashMap<Integer, ResolvedDbType>();
            Optional<String> owner = OracleConnectionUtils.getOwnerFrom(typeName);
            String type = OracleConnectionUtils.getTypeSimpleName(typeName);
            String query = owner.isPresent() ? "SELECT ATTR_NO, ATTR_TYPE_NAME FROM ALL_TYPE_ATTRS WHERE TYPE_NAME = ? AND ATTR_TYPE_NAME IN ('CLOB', 'BLOB') AND OWNER = ? UNION ALL SELECT ATTR_NO, ATTR_TYPE_NAME FROM ALL_PLSQL_TYPE_ATTRS WHERE PACKAGE_NAME = ? AND ATTR_TYPE_NAME IN ('CLOB', 'BLOB')" : QUERY_TYPE_ATTRS;
            try (PreparedStatement ps = this.prepareStatement(query);){
                ps.setString(1, type);
                if (owner.isPresent()) {
                    ps.setString(2, owner.get());
                    ps.setString(3, owner.get());
                }
                try (ResultSet resultSet = ps.executeQuery();){
                    while (resultSet.next()) {
                        ResolvedDbType resolvedDbType = new ResolvedDbType(-1, resultSet.getString(ATTR_TYPE_NAME_PARAM));
                        dataTypes.put(resultSet.getInt(ATTR_NO_PARAM), resolvedDbType);
                    }
                }
            }
            this.resolvedDbTypesCache.put(typeName, dataTypes);
            return dataTypes;
        }
    }

    @Override
    public ResultSet getProcedureColumns(String storedProcedureName, String storedProcedureOwner, String storedProcedureParentOwner, String catalogName) throws SQLException {
        ResultSet procedureColumns;
        String connectionSchema;
        DatabaseMetaData dbMetaData = this.getJdbcConnection().getMetaData();
        try {
            connectionSchema = this.getJdbcConnection().getSchema();
        }
        catch (Throwable t) {
            LOGGER.warn("You are using a not supported jdbc driver version. Consider to upgrade to a new version to guarantee a better performance.");
            connectionSchema = null;
        }
        if (!StringUtils.isBlank((CharSequence)storedProcedureParentOwner) && !StringUtils.isBlank((CharSequence)storedProcedureOwner)) {
            procedureColumns = dbMetaData.getProcedureColumns(storedProcedureParentOwner, storedProcedureOwner, storedProcedureName, "%");
        } else if (!StringUtils.isBlank((CharSequence)storedProcedureOwner)) {
            procedureColumns = dbMetaData.getProcedureColumns(storedProcedureOwner, connectionSchema, storedProcedureName, "%");
            if (!procedureColumns.isBeforeFirst()) {
                procedureColumns.close();
                procedureColumns = dbMetaData.getProcedureColumns(catalogName == null ? "" : catalogName, storedProcedureOwner, storedProcedureName, "%");
            }
        } else {
            procedureColumns = dbMetaData.getProcedureColumns(catalogName, connectionSchema, storedProcedureName, "%");
        }
        if (!procedureColumns.isBeforeFirst()) {
            LOGGER.debug("Failed to get procedure types with schema {}, package {} and procedure {}. Removing all catalog and schema filters.", new Object[]{storedProcedureOwner, storedProcedureParentOwner, storedProcedureName});
            procedureColumns = dbMetaData.getProcedureColumns(null, null, storedProcedureName, "%");
        }
        return procedureColumns;
    }

    @Override
    public Optional<DbType> getDbTypeByVendor(String typeName, ResultSet procedureColumns) throws SQLException {
        if (TABLE_TYPE_NAME.equals(typeName)) {
            String procedureName = procedureColumns.getString(3);
            String argumentName = procedureColumns.getString(4);
            String owner = procedureColumns.getString(2);
            Optional<String> columnType = this.getProcedureColumnType(procedureName, argumentName, owner);
            return columnType.map(type -> new ArrayResolvedDbType(2003, (String)type));
        }
        return Optional.empty();
    }
}

