/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.connection.oracle;

import java.util.Optional;
import org.mule.extension.db.internal.domain.connection.BaseDbConnectionParameters;
import org.mule.extension.db.internal.domain.connection.DataSourceConfig;
import org.mule.extension.db.internal.domain.connection.oracle.util.OracleTNSEntryURLBuilder;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.exception.ModuleException;

public class OracleConnectionParameters
extends BaseDbConnectionParameters
implements DataSourceConfig {
    static final String DRIVER_CLASS_NAME = "oracle.jdbc.driver.OracleDriver";
    private static final String JDBC_URL_PREFIX = "jdbc:oracle:thin:@";
    @Parameter
    @Placement(order=1)
    private String host;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="1521")
    @Placement(order=2)
    private Integer port;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Placement(order=3)
    private String user;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Placement(order=4)
    @Password
    private String password;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Placement(order=5)
    private String instance;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Placement(order=6)
    private String serviceName;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="TLS")
    @DisplayName(value="TLS Context")
    @Summary(value="The TLS factory used to create TLS secured connections")
    private TlsContextFactory tlsContextFactory;

    @Override
    public String getUrl() {
        this.checkInstanceAndServiceName();
        return this.tlsContextFactory != null ? JDBC_URL_PREFIX + this.generateSecureUrl() : this.generateBasicUrl();
    }

    @Override
    public String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public Optional<TlsContextFactory> getTlsContextFactory() {
        return Optional.ofNullable(this.tlsContextFactory);
    }

    private String generateBasicUrl() {
        StringBuilder buf = new StringBuilder(JDBC_URL_PREFIX);
        buf.append(this.host);
        buf.append(":");
        buf.append(this.port);
        if (this.instance != null) {
            buf.append(":");
            buf.append(this.instance);
        }
        if (this.serviceName != null) {
            buf.append("/");
            buf.append(this.serviceName);
        }
        return buf.toString();
    }

    private String generateSecureUrl() {
        return new OracleTNSEntryURLBuilder().withProtocol("TCPS").withHost(this.host).withPort(this.port).withInstanceName(this.instance).withServiceName(this.serviceName).build();
    }

    private void checkInstanceAndServiceName() {
        if (this.instance != null && this.serviceName != null) {
            String errorMessage = "Instance (SID) : [" + this.instance + "] and Service Name : [" + this.serviceName + "] were provided at the same time, please configure only one";
            throw new ModuleException(errorMessage, (ErrorTypeDefinition)MuleErrors.CONNECTIVITY, (Throwable)new ConnectionException(errorMessage));
        }
    }
}

