/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.connection.mysql;

import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;
import org.mule.db.commons.shaded.api.exception.connection.DbError;
import org.mule.db.commons.shaded.internal.domain.connection.DataSourceConfig;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnectionProvider;
import org.mule.extension.db.internal.domain.connection.mysql.MySqlConnectionParameters;
import org.mule.extension.db.internal.util.MigrationUtils;
import org.mule.runtime.api.meta.ExternalLibraryType;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;

@DisplayName(value="MySQL Connection")
@Alias(value="my-sql")
@ExternalLib(name="MySQL JDBC Driver", description="A JDBC driver which supports connecting to the MySQL Database", nameRegexpMatcher="(.*)\\.jar", requiredClassName="com.mysql.jdbc.Driver", type=ExternalLibraryType.JAR, coordinates="mysql:mysql-connector-java:8.0.30")
public class MySqlConnectionProvider
extends DbConnectionProvider {
    private static final String ACCESS_DENIED = "Access denied";
    private static final String UNKNOWN_DATABASE = "Unknown database";
    private static final String COMMUNICATIONS_LINK_FAILURE = "Communications link failure";
    static final String MYSQL_GAV = "mysql:mysql-connector-java:8.0.30";
    @ParameterGroup(name="Connection")
    private MySqlConnectionParameters mySqlParameters;

    @Override
    public Optional<DataSource> getDataSource() {
        return Optional.empty();
    }

    @Override
    public Optional<DataSourceConfig> getDataSourceConfig() {
        return Optional.ofNullable(MigrationUtils.mapDataSourceConfig(this.mySqlParameters));
    }

    @Override
    public Optional<DbError> getDbVendorErrorType(SQLException e) {
        String message = e.getMessage();
        if (message.contains(ACCESS_DENIED)) {
            return Optional.of(DbError.INVALID_CREDENTIALS);
        }
        if (message.contains(UNKNOWN_DATABASE)) {
            return Optional.of(DbError.INVALID_DATABASE);
        }
        if (message.contains(COMMUNICATIONS_LINK_FAILURE)) {
            return Optional.of(DbError.CANNOT_REACH);
        }
        return Optional.empty();
    }
}

