/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.connection.mysql;

import java.util.HashMap;
import java.util.Map;
import org.mule.extension.db.api.logger.MuleMySqlLogger;
import org.mule.extension.db.internal.domain.connection.BaseDbConnectionParameters;
import org.mule.extension.db.internal.domain.connection.DataSourceConfig;
import org.mule.extension.db.internal.domain.connection.mysql.MySqlDbUtils;
import org.mule.extension.db.internal.domain.logger.MuleMySqlLoggerFactory;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MySqlConnectionParameters
extends BaseDbConnectionParameters
implements DataSourceConfig {
    private static final String MY_SQL_PREFIX = "jdbc:mysql://";
    private static final String LOGGER_PROPERTY = "logger";
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlConnectionParameters.class);
    @Parameter
    @Placement(order=1)
    private String host;
    @Parameter
    @Placement(order=2)
    private Integer port;
    @Parameter
    @Optional
    @Placement(order=3)
    private String user;
    @Parameter
    @Optional
    @Placement(order=4)
    @Password
    private String password;
    @Parameter
    @Optional
    @Placement(order=5)
    private String database;
    @Parameter
    @Optional
    @Placement(tab="Advanced")
    private Map<String, String> connectionProperties = new HashMap<String, String>();

    public MySqlConnectionParameters() {
        this.addMuleLoggerProperty(this.connectionProperties);
    }

    @Override
    public String getUrl() {
        return MySqlDbUtils.getEffectiveUrl(MY_SQL_PREFIX, this.host, this.port, this.database, this.connectionProperties);
    }

    @Override
    public String getDriverClassName() {
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            return "com.mysql.cj.jdbc.Driver";
        }
        catch (ClassNotFoundException e) {
            return "com.mysql.jdbc.Driver";
        }
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    public Map<String, String> getConnectionProperties() {
        return this.connectionProperties;
    }

    private void addMuleLoggerProperty(Map<String, String> connectionProperties) {
        block3: {
            if (connectionProperties != null) {
                try {
                    MuleMySqlLogger muleMySqlLogger = new MuleMySqlLogger("MySql");
                    MuleMySqlLogger enhancedLogger = new MuleMySqlLoggerFactory(Thread.currentThread().getContextClassLoader(), muleMySqlLogger).create();
                    connectionProperties.putIfAbsent(LOGGER_PROPERTY, enhancedLogger.getClass().getName());
                }
                catch (Throwable e) {
                    LOGGER.warn(String.format("Unable to attach Mule Logger to MySql Driver. Cause: %s", e.getMessage()));
                    if (!LOGGER.isDebugEnabled()) break block3;
                    LOGGER.debug("Unable to attach Mule Logger to MySql Driver", e);
                }
            }
        }
    }
}

