/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.connection.derby;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Optional;
import javax.sql.DataSource;
import org.mule.db.commons.shaded.api.exception.connection.DbError;
import org.mule.db.commons.shaded.internal.domain.connection.DataSourceConfig;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnectionProvider;
import org.mule.extension.db.internal.domain.connection.derby.DerbyConnection;
import org.mule.extension.db.internal.domain.connection.derby.DerbyConnectionParameters;
import org.mule.extension.db.internal.util.MigrationUtils;
import org.mule.runtime.api.meta.ExternalLibraryType;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;

@DisplayName(value="Derby Connection")
@Alias(value="derby")
@ExternalLib(name="Derby JDBC Driver", description="A JDBC driver which supports connecting to a Derby Database", nameRegexpMatcher="(.*)\\.jar", requiredClassName="org.apache.derby.jdbc.EmbeddedDriver", type=ExternalLibraryType.JAR, coordinates="org.apache.derby:derby:10.14.2.0")
public class DerbyConnectionProvider
extends DbConnectionProvider {
    private static final String FAILED_TO_START_DATABASE = "Failed to start database";
    private static final String NOT_FOUND = "not found";
    static final String DERBY_GAV = "org.apache.derby:derby:10.14.2.0";
    @ParameterGroup(name="Connection")
    private DerbyConnectionParameters derbyParameters;

    @Override
    public Optional<DataSource> getDataSource() {
        return Optional.empty();
    }

    @Override
    public Optional<DataSourceConfig> getDataSourceConfig() {
        return Optional.ofNullable(MigrationUtils.mapDataSourceConfig(this.derbyParameters));
    }

    @Override
    protected DbConnection createDbConnection(Connection connection) throws Exception {
        return new DerbyConnection(connection, this.resolveCustomTypes(), this.cachedTemplates);
    }

    @Override
    public Optional<DbError> getDbVendorErrorType(SQLException e) {
        if (Arrays.stream(new String[]{FAILED_TO_START_DATABASE, NOT_FOUND}).anyMatch(e.getMessage()::contains)) {
            return Optional.of(DbError.CANNOT_REACH);
        }
        return Optional.empty();
    }
}

