/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.connection.derby;

import java.util.HashMap;
import java.util.Map;
import org.mule.extension.db.internal.domain.connection.BaseDbConnectionParameters;
import org.mule.extension.db.internal.domain.connection.DataSourceConfig;
import org.mule.extension.db.internal.domain.connection.derby.DerbySubsubProtocolValueProvider;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;

public final class DerbyConnectionParameters
extends BaseDbConnectionParameters
implements DataSourceConfig {
    private static final String JDBC_URL_PREFIX = "jdbc:derby";
    static final String DERBY_DRIVER_CLASS = "org.apache.derby.jdbc.EmbeddedDriver";
    @Parameter
    @Optional
    @Placement(order=1)
    private String database;
    @Parameter
    @Optional(defaultValue="directory")
    @Placement(order=2)
    @OfValues(value=DerbySubsubProtocolValueProvider.class)
    private String subsubProtocol;
    @Parameter
    @Optional(defaultValue="false")
    @Placement(order=3)
    private boolean create;
    @Parameter
    @Optional
    @Placement(tab="Advanced")
    private Map<String, String> connectionProperties = new HashMap<String, String>();

    @Override
    public String getUrl() {
        StringBuilder buf = new StringBuilder();
        buf.append(JDBC_URL_PREFIX);
        if (this.subsubProtocol != null) {
            buf.append(":");
            buf.append(this.subsubProtocol);
        }
        if (this.database != null) {
            buf.append(":");
            buf.append(this.database);
        }
        if (this.create) {
            buf.append(";create=true");
        }
        if (this.connectionProperties != null) {
            this.connectionProperties.entrySet().forEach(entry -> {
                buf.append(";");
                buf.append((String)entry.getKey());
                buf.append("=");
                buf.append((String)entry.getValue());
            });
        }
        return buf.toString();
    }

    @Override
    public String getDriverClassName() {
        return DERBY_DRIVER_CLASS;
    }

    @Override
    public String getPassword() {
        return null;
    }

    @Override
    public String getUser() {
        return null;
    }
}

