/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.connection.datasource;

import com.github.benmanes.caffeine.cache.Cache;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.db.commons.shaded.internal.domain.connection.datasource.DataSourceReferenceConnectionProvider;
import org.mule.db.commons.shaded.internal.domain.query.QueryTemplate;
import org.mule.db.commons.shaded.internal.domain.type.ResolvedDbType;
import org.mule.extension.db.internal.domain.connection.ConnectionUtils;
import org.mule.extension.db.internal.domain.connection.oracle.OracleDbConnection;
import org.mule.runtime.api.meta.ExternalLibraryType;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;

@DisplayName(value="Data Source Reference Connection")
@Alias(value="data-source")
@ExternalLib(name="JDBC Driver", description="A JDBC driver which supports connecting to the Database", nameRegexpMatcher="(.*)\\.jar", type=ExternalLibraryType.JAR, optional=true)
public class DbDataSourceReferenceConnectionProvider
extends DataSourceReferenceConnectionProvider {
    private final Map<String, Map<Integer, ResolvedDbType>> resolvedDbTypesCache = new ConcurrentHashMap<String, Map<Integer, ResolvedDbType>>();
    private final ConcurrentHashMap<String, String> resolvedDbTypeNamesCache = new ConcurrentHashMap();

    @Override
    protected DbConnection createDbConnection(Connection connection) throws Exception {
        if (ConnectionUtils.isOracle(connection)) {
            return new OracleDbConnection(connection, super.resolveCustomTypes(), this.resolvedDbTypesCache, (Cache<String, QueryTemplate>)this.cachedTemplates, this.resolvedDbTypeNamesCache);
        }
        return super.createDbConnection(connection);
    }
}

