/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.api.param;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.db.commons.shaded.internal.domain.metadata.DbInputMetadataResolver;
import org.mule.extension.db.api.param.StatementDefinition;
import org.mule.extension.db.internal.util.ExcludeFromGeneratedCoverage;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

public abstract class ParameterizedStatementDefinition<T extends ParameterizedStatementDefinition>
extends StatementDefinition<T> {
    @Parameter
    @Content
    @org.mule.runtime.extension.api.annotation.param.Optional
    @NullSafe
    @TypeResolver(value=DbInputMetadataResolver.class)
    @Placement(order=2)
    @DisplayName(value="Input Parameters")
    @Example(value="#[{'name': \"Max\", 'nickname': \"The Mule\", 'company': \"MuleSoft\"}]")
    protected Map<String, Object> inputParameters = new LinkedHashMap<String, Object>();

    @ExcludeFromGeneratedCoverage
    public Optional<Reference<Object>> getInputParameter(String name) {
        return this.findParameter(this.getInputParameters(), name);
    }

    protected Optional<Reference<Object>> findParameter(Map<String, Object> parameters, String name) {
        return parameters.containsKey(name) ? Optional.of(new Reference(parameters.get(name))) : Optional.empty();
    }

    public Map<String, Object> getInputParameters() {
        return Collections.unmodifiableMap(this.inputParameters);
    }

    public void addInputParameter(String paramName, Object value) {
        this.inputParameters.put(paramName, value);
    }

    @Override
    protected T copy() {
        ParameterizedStatementDefinition copy = (ParameterizedStatementDefinition)super.copy();
        this.getInputParameters().forEach(copy::addInputParameter);
        return (T)copy;
    }
}

