/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal.util;

import com.google.gson.Gson;
import com.mchange.v2.c3p0.PooledDataSource;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.sql.DataSource;
import org.enhydra.jdbc.standard.StandardXADataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbPoolingProfileLoggerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbPoolingProfileLoggerUtils.class);
    private static final String POOLING_DATA_LOGGER_MBEAN_PATTERN = "mule.db.connector.pooling.logger.pattern";
    private static final String INITIATION_POLLING_PHRASE = "Pooling data being gathered at {} method";

    private DbPoolingProfileLoggerUtils() {
        throw new IllegalStateException("Utility class - Do not instantiate.");
    }

    public static void getC3P0sPoolingData(DataSource dataSource, String caller) {
        if (LOGGER.isTraceEnabled() && dataSource instanceof PooledDataSource) {
            try {
                LOGGER.trace(INITIATION_POLLING_PHRASE, (Object)caller);
                PooledDataSource pooledDataSource = (PooledDataSource)dataSource;
                HashMap<String, Number> poolingData = new HashMap<String, Number>();
                poolingData.put("NumConnections", pooledDataSource.getNumConnectionsDefaultUser());
                poolingData.put("NumBusyConnections: ", pooledDataSource.getNumBusyConnectionsDefaultUser());
                poolingData.put("NumIdleConnections: ", pooledDataSource.getNumIdleConnectionsDefaultUser());
                poolingData.put("NumUnclosedOrphanedConnections", pooledDataSource.getNumUnclosedOrphanedConnectionsDefaultUser());
                poolingData.put("StatementCacheNumStatements", pooledDataSource.getStatementCacheNumStatementsDefaultUser());
                poolingData.put("StatementCacheNumCheckedOut", pooledDataSource.getStatementCacheNumCheckedOutDefaultUser());
                poolingData.put("StatementCacheNumConnectionsWithCached", pooledDataSource.getStatementCacheNumConnectionsWithCachedStatementsDefaultUser());
                poolingData.put("StartTimeMillis", pooledDataSource.getStartTimeMillisDefaultUser());
                poolingData.put("UpTimeMillis", pooledDataSource.getUpTimeMillisDefaultUser());
                poolingData.put("NumFailedCheckins", pooledDataSource.getNumFailedCheckinsDefaultUser());
                poolingData.put("NumFailedIdleTests", pooledDataSource.getNumFailedIdleTestsDefaultUser());
                poolingData.put("EffectivePropertyCycle", Float.valueOf(pooledDataSource.getEffectivePropertyCycleDefaultUser()));
                poolingData.put("NumThreadsAwaitingCheckout", pooledDataSource.getNumThreadsAwaitingCheckoutDefaultUser());
                LOGGER.trace(((Object)poolingData).toString());
            }
            catch (SQLException sqlException) {
                LOGGER.error("An error occurred while gathering pooling data: {}", (Object)sqlException.getMessage());
            }
        }
    }

    public static void getXAPoolData(DataSource dataSource, String caller) {
        if (LOGGER.isTraceEnabled()) {
            boolean fieldChanged = false;
            boolean isAccessible = false;
            Field xaDataSourceField = null;
            try {
                LOGGER.trace(INITIATION_POLLING_PHRASE, (Object)caller);
                Method getWrappedDataSourceMethod = dataSource.getClass().getMethod("getWrappedDataSource", new Class[0]);
                Object poolingDataSource = getWrappedDataSourceMethod.invoke((Object)dataSource, new Object[0]);
                Method toStringMethod = poolingDataSource.getClass().getMethod("toString", new Class[0]);
                xaDataSourceField = poolingDataSource.getClass().getDeclaredField("xaDataSource");
                isAccessible = xaDataSourceField.isAccessible();
                xaDataSourceField.setAccessible(true);
                fieldChanged = true;
                StandardXADataSource xa = (StandardXADataSource)xaDataSourceField.get(null);
                xaDataSourceField.setAccessible(isAccessible);
                HashMap<String, Object> poolingData = new HashMap<String, Object>();
                poolingData.put("Bitronix.PoolingDataSource", toStringMethod.invoke(poolingDataSource, new Object[0]));
                poolingData.put("AllConnections", xa.getAllConnections());
                poolingData.put("ConnectionCount", xa.getConnectionCount());
                poolingData.put("DeadLockMaxWait", xa.getDeadLockMaxWait());
                poolingData.put("DeadLockRetryWait", xa.getDeadLockRetryWait());
                poolingData.put("MaxCon", xa.getMaxCon());
                poolingData.put("MinCon", xa.getMinCon());
                poolingData.put("LoginTimeout", xa.getLoginTimeout());
                poolingData.put("PreparedStmtCacheSize", xa.getPreparedStmtCacheSize());
                LOGGER.trace(((Object)poolingData).toString());
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException exception) {
                if (fieldChanged) {
                    xaDataSourceField.setAccessible(isAccessible);
                }
                LOGGER.error("An error occurred while gathering pooling data: {}", (Object)exception.getMessage());
            }
        }
    }

    public static void getDataSourcePoolData(String caller) {
        if (LOGGER.isTraceEnabled()) {
            String searchPattern = DbPoolingProfileLoggerUtils.getMBeanPattern();
            if (searchPattern != null) {
                LOGGER.trace(INITIATION_POLLING_PHRASE, (Object)caller);
                MBeanServer mBeanServerConnection = ManagementFactory.getPlatformMBeanServer();
                List<Map<String, String>> poolingData = DbPoolingProfileLoggerUtils.getConnectionPoolStats(searchPattern, mBeanServerConnection);
                LOGGER.trace(new Gson().toJson(poolingData));
            } else {
                LOGGER.trace("Couldn't gather datasource pooling data, no MBean Search Pattern provided. Use system property mule.db.connector.pooling.logger.pattern");
            }
        }
    }

    private static List<Map<String, String>> getConnectionPoolStats(String searchPattern, MBeanServerConnection mBeanServer) {
        LOGGER.trace("MBean Search pattern {} ", (Object)searchPattern);
        ArrayList<Map<String, String>> stats = new ArrayList<Map<String, String>>();
        try {
            Set<ObjectName> objects = mBeanServer.queryNames(new ObjectName(searchPattern), null);
            if (!objects.isEmpty()) {
                for (ObjectName obj : objects) {
                    MBeanAttributeInfo[] attr;
                    HashMap<String, String> infoMap = new HashMap<String, String>();
                    MBeanInfo info = mBeanServer.getMBeanInfo(obj);
                    for (MBeanAttributeInfo mBeanAttributeInfo : attr = info.getAttributes()) {
                        String name = mBeanAttributeInfo.getName();
                        if (!mBeanAttributeInfo.isReadable()) continue;
                        DbPoolingProfileLoggerUtils.readAttributesValue(mBeanServer, obj, infoMap, name);
                    }
                    stats.add(infoMap);
                }
                return stats;
            }
            LOGGER.trace("MBean Search pattern returned zero results, no pooling data gathered.");
        }
        catch (Exception e) {
            LOGGER.error("Error while gathering pooling data: {}", (Object)e.getMessage());
        }
        return stats;
    }

    private static void readAttributesValue(MBeanServerConnection mBeanServer, ObjectName obj, Map<String, String> infoMap, String name) {
        try {
            Object value = mBeanServer.getAttribute(obj, name);
            infoMap.put(name, String.valueOf(value));
        }
        catch (Exception e) {
            LOGGER.error("Error in reading config {}, error {}", (Object)name, (Object)e);
        }
    }

    private static String getMBeanPattern() {
        return System.getProperty(POOLING_DATA_LOGGER_MBEAN_PATTERN);
    }
}

