/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CredentialsMaskUtils {
    public static final Pattern BARE_URL_PASSWORD_PATTERN = Pattern.compile("[a-z]*://[a-zA-Z0-9%._-]*:([^@]*)@");
    public static final Pattern BARE_URL_PATTERN = Pattern.compile("[a-z]*://([^@]*)@");
    public static final Pattern URL_PATTERN = Pattern.compile("url=\"[a-z]*://([^@]*)@");
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("address=\"[a-z]*://([^@]*)@");
    public static final Pattern PASSWORD_PATTERN = Pattern.compile("password=\"([^\"]*)\"");
    public static final Pattern PASSWORD_PATTERN_NO_QUOTES = Pattern.compile("password=([^\\s;]+)");
    public static final Pattern USER_PATTERN_NO_QUOTES = Pattern.compile("user=([^\\s;]+)");
    public static final String PASSWORD_MASK = "<<credentials>>";
    public static final String USER_MASK = "<<user>>";
    public static final String PASSWORD_ATTRIBUTE_MASK = "password=\"%s\"";
    protected static final String USER_URL_PREFIX = "user=";
    protected static final String PASSWORD_URL_PREFIX = "password=";

    public static String maskPasswords(String input) {
        input = CredentialsMaskUtils.maskUrlPassword(input, URL_PATTERN);
        Matcher matcher = PASSWORD_PATTERN.matcher(input = CredentialsMaskUtils.maskUrlPassword(input, ADDRESS_PATTERN));
        if (matcher.find() && matcher.groupCount() > 0) {
            input = input.replace(CredentialsMaskUtils.maskPasswordAttribute(matcher.group(1)), CredentialsMaskUtils.maskPasswordAttribute(PASSWORD_MASK));
        }
        return input;
    }

    public static String maskUrlPassword(String input, Pattern pattern) {
        return CredentialsMaskUtils.maskUrlPattern(input, pattern, PASSWORD_MASK);
    }

    public static String maskUrlPasswordWithMask(String input, Pattern pattern, String mask) {
        return CredentialsMaskUtils.maskUrlPattern(input, pattern, mask);
    }

    public static String maskUrlUserAndPassword(String input, Pattern passwordPattern, Pattern userPattern) {
        String inputMasked = CredentialsMaskUtils.maskUrlPattern(input, passwordPattern, PASSWORD_MASK, PASSWORD_URL_PREFIX);
        return CredentialsMaskUtils.maskUrlPattern(inputMasked, userPattern, USER_MASK, USER_URL_PREFIX);
    }

    public static String maskUrlUserAndPassword(String input) {
        String inputMasked = CredentialsMaskUtils.maskUrlPattern(input, PASSWORD_PATTERN_NO_QUOTES, PASSWORD_MASK, PASSWORD_URL_PREFIX);
        inputMasked = CredentialsMaskUtils.maskUrlPattern(inputMasked, USER_PATTERN_NO_QUOTES, USER_MASK, PASSWORD_URL_PREFIX);
        inputMasked = CredentialsMaskUtils.maskUrlPattern(inputMasked, PASSWORD_PATTERN, PASSWORD_MASK, PASSWORD_URL_PREFIX);
        return inputMasked;
    }

    public static String maskPasswordAttribute(String password) {
        return String.format(PASSWORD_ATTRIBUTE_MASK, password);
    }

    protected static String maskUrlPattern(String input, Pattern pattern, String mask) {
        return CredentialsMaskUtils.maskUrlPattern(input, pattern, mask, "");
    }

    protected static String maskUrlPattern(String input, Pattern pattern, String mask, String prefix) {
        Matcher matcher = pattern.matcher(input);
        if (matcher.find() && matcher.groupCount() > 0) {
            input = input.replace(matcher.group(1), mask);
        }
        return input;
    }
}

