/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal.result.statement;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.mule.db.commons.shaded.internal.domain.autogeneratedkey.AutoGenerateKeysStrategy;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.db.commons.shaded.internal.domain.query.QueryTemplate;
import org.mule.db.commons.shaded.internal.result.resultset.ResultSetHandler;
import org.mule.db.commons.shaded.internal.result.statement.SingleStatementResult;
import org.mule.db.commons.shaded.internal.result.statement.StatementResultHandler;
import org.mule.db.commons.shaded.internal.result.statement.StatementResultIterator;
import org.mule.db.commons.shaded.internal.result.statement.StatementResultIteratorFactory;

public abstract class AbstractMapStatementResultHandler
implements StatementResultHandler {
    private final ResultSetHandler resultSetHandler;

    protected AbstractMapStatementResultHandler(ResultSetHandler resultSetHandler) {
        this.resultSetHandler = resultSetHandler;
    }

    @Override
    public Map<String, Object> processStatement(DbConnection connection, Statement statement, QueryTemplate queryTemplate, AutoGenerateKeysStrategy autoGenerateKeysStrategy) throws SQLException {
        Map<String, Object> result = this.createResultMap();
        StatementResultIteratorFactory statementResultIteratorFactory = connection.getStatementResultIteratorFactory(this.resultSetHandler);
        StatementResultIterator statementResultIterator = statementResultIteratorFactory.create(connection, statement, queryTemplate, autoGenerateKeysStrategy);
        while (statementResultIterator.hasNext()) {
            SingleStatementResult next = statementResultIterator.next();
            result.put(next.getName(), next.getResult());
        }
        return result;
    }

    protected abstract Map<String, Object> createResultMap();
}

