/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal.result.resultset;

import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.db.commons.shaded.internal.result.row.RowHandler;
import org.mule.db.commons.shaded.internal.util.ResultSetCharsetEncodedHandler;
import org.mule.runtime.core.api.util.CaseInsensitiveHashMap;

public class SingleResultSetHandler
implements ResultSetCharsetEncodedHandler {
    private final RowHandler rowHandler;
    private final Charset charset;

    public SingleResultSetHandler(RowHandler rowHandler) {
        this.rowHandler = rowHandler;
        this.charset = Charset.defaultCharset();
    }

    public SingleResultSetHandler(RowHandler rowHandler, Charset charset) {
        this.rowHandler = rowHandler;
        this.charset = charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> processResultSet(DbConnection connection, ResultSet resultSet) throws SQLException {
        try {
            if (resultSet.next()) {
                Map<String, Object> map = this.rowHandler.process(resultSet);
                return map;
            }
        }
        finally {
            resultSet.close();
        }
        return new CaseInsensitiveHashMap();
    }

    @Override
    public boolean requiresMultipleOpenedResults() {
        return false;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }
}

