/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal.result.resultset;

import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.mule.db.commons.shaded.internal.StatementStreamingResultSetCloser;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.db.commons.shaded.internal.result.resultset.ResultSetIterator;
import org.mule.db.commons.shaded.internal.result.row.RowHandler;
import org.mule.db.commons.shaded.internal.util.ResultSetCharsetEncodedHandler;

public class IteratorResultSetHandler
implements ResultSetCharsetEncodedHandler {
    private final RowHandler rowHandler;
    private final StatementStreamingResultSetCloser streamingResultSetCloser;
    private final Charset charset;

    public IteratorResultSetHandler(RowHandler rowHandler, StatementStreamingResultSetCloser streamingResultSetCloser) {
        this.rowHandler = rowHandler;
        this.streamingResultSetCloser = streamingResultSetCloser;
        this.charset = Charset.defaultCharset();
    }

    public IteratorResultSetHandler(RowHandler rowHandler, StatementStreamingResultSetCloser streamingResultSetCloser, Charset charset) {
        this.rowHandler = rowHandler;
        this.streamingResultSetCloser = streamingResultSetCloser;
        this.charset = charset;
    }

    @Override
    public ResultSetIterator processResultSet(DbConnection connection, ResultSet resultSet) throws SQLException {
        this.streamingResultSetCloser.trackResultSet(resultSet);
        connection.beginStreaming();
        return new ResultSetIterator(resultSet, this.rowHandler);
    }

    @Override
    public boolean requiresMultipleOpenedResults() {
        return true;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }
}

