/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal.resolver.query;

import java.io.IOException;
import org.mule.db.commons.shaded.internal.parser.QueryTemplateParser;
import org.mule.db.commons.shaded.internal.resolver.query.BulkQueryFactory;
import org.mule.db.commons.shaded.internal.resolver.query.QueryResolutionException;
import org.mule.db.commons.shaded.internal.util.FileReader;

public class FileBulkQueryFactory
extends BulkQueryFactory {
    private final String file;
    private final FileReader fileReader;

    public FileBulkQueryFactory(String file, QueryTemplateParser queryTemplateParser, FileReader fileReader) {
        super(queryTemplateParser);
        this.file = file;
        this.fileReader = fileReader;
    }

    @Override
    protected String resolveBulkQueries() {
        try {
            return this.fileReader.getResourceAsString(this.file);
        }
        catch (IOException e) {
            throw new QueryResolutionException("Unable to read script file: " + this.file);
        }
    }

    public String toString() {
        return this.file;
    }
}

