/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal.resolver.query;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.mule.db.commons.shaded.AbstractDbConnector;
import org.mule.db.commons.shaded.api.param.BulkQueryDefinition;
import org.mule.db.commons.shaded.api.param.ParameterType;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.db.commons.shaded.internal.domain.param.DefaultInputQueryParam;
import org.mule.db.commons.shaded.internal.domain.param.InputQueryParam;
import org.mule.db.commons.shaded.internal.domain.param.QueryParam;
import org.mule.db.commons.shaded.internal.domain.query.Query;
import org.mule.db.commons.shaded.internal.domain.query.QueryParamValue;
import org.mule.db.commons.shaded.internal.domain.query.QueryTemplate;
import org.mule.db.commons.shaded.internal.resolver.query.AbstractQueryResolver;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public class BulkQueryResolver
extends AbstractQueryResolver<BulkQueryDefinition> {
    @Override
    public Query resolve(BulkQueryDefinition definition, AbstractDbConnector connector, DbConnection connection, StreamingHelper streamingHelper) {
        Query query = super.resolve(definition, connector, connection, streamingHelper);
        LinkedList<QueryParam> queryParams = new LinkedList<QueryParam>();
        QueryTemplate queryTemplate = query.getQueryTemplate();
        queryTemplate.getParams().forEach(inputParam -> {
            String paramName;
            Optional<ParameterType> parameterType;
            if (inputParam instanceof InputQueryParam && (parameterType = definition.getParameterType(paramName = inputParam.getName())).isPresent()) {
                queryParams.add(new DefaultInputQueryParam(inputParam.getIndex(), parameterType.get().getDbType(), null, paramName));
                return;
            }
            queryParams.add((QueryParam)inputParam);
        });
        return new Query(new QueryTemplate(queryTemplate.getSqlText(), queryTemplate.getType(), queryParams, queryTemplate.isDynamic()));
    }

    @Override
    protected List<QueryParamValue> resolveParams(BulkQueryDefinition statementDefinition, QueryTemplate template, StreamingHelper streamingHelper) {
        return new LinkedList<QueryParamValue>();
    }
}

