/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal.resolver.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.db.commons.shaded.AbstractDbConnector;
import org.mule.db.commons.shaded.api.param.ParameterType;
import org.mule.db.commons.shaded.api.param.StatementDefinition;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.db.commons.shaded.internal.domain.param.AbstractQueryParam;
import org.mule.db.commons.shaded.internal.domain.param.DefaultInOutQueryParam;
import org.mule.db.commons.shaded.internal.domain.param.DefaultInputQueryParam;
import org.mule.db.commons.shaded.internal.domain.param.DefaultOutputQueryParam;
import org.mule.db.commons.shaded.internal.domain.param.InOutQueryParam;
import org.mule.db.commons.shaded.internal.domain.param.InputQueryParam;
import org.mule.db.commons.shaded.internal.domain.param.OutputQueryParam;
import org.mule.db.commons.shaded.internal.domain.param.QueryParam;
import org.mule.db.commons.shaded.internal.domain.query.Query;
import org.mule.db.commons.shaded.internal.domain.query.QueryParamValue;
import org.mule.db.commons.shaded.internal.domain.query.QueryTemplate;
import org.mule.db.commons.shaded.internal.domain.type.CompositeDbTypeManager;
import org.mule.db.commons.shaded.internal.domain.type.DbType;
import org.mule.db.commons.shaded.internal.domain.type.DbTypeManager;
import org.mule.db.commons.shaded.internal.domain.type.DynamicDbType;
import org.mule.db.commons.shaded.internal.domain.type.StaticDbTypeManager;
import org.mule.db.commons.shaded.internal.domain.type.UnknownDbType;
import org.mule.db.commons.shaded.internal.parser.QueryTemplateParser;
import org.mule.db.commons.shaded.internal.parser.SimpleQueryTemplateParser;
import org.mule.db.commons.shaded.internal.resolver.param.GenericParamTypeResolverFactory;
import org.mule.db.commons.shaded.internal.resolver.query.QueryResolutionException;
import org.mule.db.commons.shaded.internal.resolver.query.QueryResolver;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public abstract class AbstractQueryResolver<T extends StatementDefinition<?>>
implements QueryResolver<T> {
    private QueryTemplateParser queryTemplateParser = new SimpleQueryTemplateParser();

    @Override
    public Query resolve(T statementDefinition, AbstractDbConnector connector, DbConnection connection, StreamingHelper streamingHelper) {
        QueryTemplate queryTemplate = this.getQueryTemplate(connector, connection, statementDefinition);
        return new Query(queryTemplate, this.resolveParams(statementDefinition, queryTemplate, streamingHelper));
    }

    protected abstract List<QueryParamValue> resolveParams(T var1, QueryTemplate var2, StreamingHelper var3);

    protected QueryTemplate createQueryTemplate(T statementDefinition, AbstractDbConnector connector, DbConnection connection) {
        if (StringUtils.isBlank((CharSequence)((StatementDefinition)statementDefinition).getSql())) {
            throw new IllegalArgumentException("Statement doesn't contain a SQL query. Please provide one or reference a template which does");
        }
        QueryTemplate queryTemplate = this.queryTemplateParser.parse(((StatementDefinition)statementDefinition).getSql());
        if (this.needsParamTypeResolution(queryTemplate)) {
            List<ParameterType> parameterTypes = ((StatementDefinition)statementDefinition).getParameterTypes();
            Map<Integer, DbType> paramTypes = this.getParameterTypes(connector, connection, queryTemplate, parameterTypes);
            queryTemplate = this.resolveQueryTemplate(queryTemplate, paramTypes);
        }
        return queryTemplate;
    }

    private Map<Integer, DbType> getParameterTypes(AbstractDbConnector connector, DbConnection connection, QueryTemplate queryTemplate, List<ParameterType> types) {
        GenericParamTypeResolverFactory paramTypeResolverFactory = new GenericParamTypeResolverFactory(this.createTypeManager(connector, connection));
        try {
            return paramTypeResolverFactory.create(queryTemplate).getParameterTypes(connection, queryTemplate, types);
        }
        catch (SQLException e) {
            throw new QueryResolutionException("Cannot resolve parameter types", e);
        }
    }

    private QueryTemplate getQueryTemplate(AbstractDbConnector connector, DbConnection connection, T statementDefinition) {
        try {
            return (QueryTemplate)connection.getCacheTemplates().get((Object)((StatementDefinition)statementDefinition).getSql(), key -> this.createQueryTemplate(statementDefinition, connector, connection));
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() instanceof ModuleException) {
                throw (ModuleException)e.getCause();
            }
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not resolve query: " + ((StatementDefinition)statementDefinition).getSql())), (Throwable)e);
        }
    }

    private QueryTemplate resolveQueryTemplate(QueryTemplate queryTemplate, Map<Integer, DbType> paramTypes) {
        ArrayList<QueryParam> newParams = new ArrayList<QueryParam>();
        for (QueryParam originalParam : queryTemplate.getParams()) {
            AbstractQueryParam newParam;
            DbType type = paramTypes.get(originalParam.getIndex());
            if (type == null) {
                throw new IllegalArgumentException("Unknown parameter type of " + originalParam.getName());
            }
            if (originalParam instanceof InOutQueryParam) {
                newParam = new DefaultInOutQueryParam(originalParam.getIndex(), type, originalParam.getName(), ((InOutQueryParam)originalParam).getValue());
            } else if (originalParam instanceof InputQueryParam) {
                newParam = new DefaultInputQueryParam(originalParam.getIndex(), type, ((InputQueryParam)originalParam).getValue(), originalParam.getName());
            } else if (originalParam instanceof OutputQueryParam) {
                newParam = new DefaultOutputQueryParam(originalParam.getIndex(), type, originalParam.getName());
            } else {
                throw new IllegalArgumentException("Unknown parameter type: " + originalParam.getClass().getName());
            }
            newParams.add(newParam);
        }
        return new QueryTemplate(queryTemplate.getSqlText(), queryTemplate.getType(), newParams);
    }

    private boolean needsParamTypeResolution(QueryTemplate template) {
        return template.getParams().stream().map(QueryParam::getType).anyMatch(type -> type == UnknownDbType.getInstance() || type instanceof DynamicDbType);
    }

    protected DbTypeManager createTypeManager(AbstractDbConnector connector, DbConnection connection) {
        LinkedList<DbTypeManager> typeManagers = new LinkedList<DbTypeManager>();
        LinkedList<DbTypeManager> vendorTypeManagers = new LinkedList<DbTypeManager>();
        typeManagers.add(connector.getTypeManager());
        this.collectTypeManager(vendorTypeManagers, connection.getVendorDataTypes());
        this.collectTypeManager(vendorTypeManagers, connection.getCustomDataTypes());
        return new CompositeDbTypeManager(vendorTypeManagers, typeManagers);
    }

    private void collectTypeManager(List<DbTypeManager> collector, List<DbType> extraDataTypes) {
        if (!CollectionUtils.isEmpty(extraDataTypes)) {
            collector.add(new StaticDbTypeManager(extraDataTypes));
        }
    }
}

