/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal.parser.statement.detector;

import java.util.Arrays;
import java.util.List;
import org.mule.db.commons.shaded.internal.domain.query.QueryType;
import org.mule.db.commons.shaded.internal.parser.statement.detector.AbstractStatementTypeDetector;
import org.mule.db.commons.shaded.internal.parser.statement.detector.DeleteStatementTypeDetector;
import org.mule.db.commons.shaded.internal.parser.statement.detector.InsertStatementTypeDetector;
import org.mule.db.commons.shaded.internal.parser.statement.detector.MergeStatementTypeDetector;
import org.mule.db.commons.shaded.internal.parser.statement.detector.SelectStatementTypeDetector;
import org.mule.db.commons.shaded.internal.parser.statement.detector.StoredProcedureStatementTypeDetector;
import org.mule.db.commons.shaded.internal.parser.statement.detector.TruncateStatementTypeDetector;
import org.mule.db.commons.shaded.internal.parser.statement.detector.UnknownStatementTypeException;
import org.mule.db.commons.shaded.internal.parser.statement.detector.UpdateStatementTypeDetector;
import org.mule.db.commons.shaded.internal.parser.statement.detector.WithStatementTypeDetector;

public class StatementTypeDetector {
    private final List<AbstractStatementTypeDetector> detectors = Arrays.asList(new SelectStatementTypeDetector(), new InsertStatementTypeDetector(), new DeleteStatementTypeDetector(), new UpdateStatementTypeDetector(), new StoredProcedureStatementTypeDetector(), new TruncateStatementTypeDetector(), new MergeStatementTypeDetector(), new WithStatementTypeDetector());

    public QueryType detect(String sql) throws UnknownStatementTypeException {
        return this.detectors.stream().filter(x -> x.isOfType(sql)).findFirst().map(AbstractStatementTypeDetector::getType).orElseThrow(() -> new UnknownStatementTypeException("Cannot detect the statement type for query :" + sql));
    }
}

