/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal.operation;

import java.sql.SQLException;
import java.util.Optional;
import java.util.function.Function;
import org.mule.db.commons.shaded.AbstractDbConnector;
import org.mule.db.commons.shaded.api.param.ParameterizedStatementDefinition;
import org.mule.db.commons.shaded.api.param.QueryDefinition;
import org.mule.db.commons.shaded.api.param.QuerySettings;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.db.commons.shaded.internal.domain.executor.QueryExecutor;
import org.mule.db.commons.shaded.internal.domain.query.Query;
import org.mule.db.commons.shaded.internal.domain.query.QueryType;
import org.mule.db.commons.shaded.internal.domain.statement.ConfigurableStatementFactory;
import org.mule.db.commons.shaded.internal.operation.BaseDbOperations;
import org.mule.db.commons.shaded.internal.resolver.query.QueryResolver;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public class DdlOperations
extends BaseDbOperations {
    private DdlOperations(QueryResolver<ParameterizedStatementDefinition> queryResolver, ConfigurableStatementFactory statementFactory, Function<ConfigurableStatementFactory, QueryExecutor> updateExecutor) {
        super(queryResolver, statementFactory, updateExecutor);
    }

    public int executeDdl(String sql, QuerySettings settings, AbstractDbConnector connector, DbConnection connection, StreamingHelper streamingHelper) throws SQLException {
        QueryDefinition query = new QueryDefinition();
        query.setSql(sql);
        query.copyInto(settings);
        Query resolvedQuery = this.resolveQuery(query, connector, connection, streamingHelper, QueryType.DDL);
        return this.executeUpdate(query, null, connection, resolvedQuery).getAffectedRows();
    }

    public static class Builder {
        private Optional<QueryResolver<ParameterizedStatementDefinition>> queryResolverOptional = Optional.empty();
        private Optional<ConfigurableStatementFactory> statementFactoryOptional = Optional.empty();
        private Optional<Function<ConfigurableStatementFactory, QueryExecutor>> updateExecutorOptional = Optional.empty();

        public Builder withQueryResolver(QueryResolver<ParameterizedStatementDefinition> queryResolver) {
            this.queryResolverOptional = Optional.of(queryResolver);
            return this;
        }

        public Builder withStatementFactory(ConfigurableStatementFactory statementFactory) {
            this.statementFactoryOptional = Optional.of(statementFactory);
            return this;
        }

        public Builder withUpdateExecutor(Function<ConfigurableStatementFactory, QueryExecutor> updateExecutor) {
            this.updateExecutorOptional = Optional.of(updateExecutor);
            return this;
        }

        public DdlOperations build() {
            return new DdlOperations(this.queryResolverOptional.orElse(BaseDbOperations.getDefaultQueryResolver()), this.statementFactoryOptional.orElse(BaseDbOperations.getDefaultStatementFactory()), this.updateExecutorOptional.orElse(BaseDbOperations.getDefaultUpdateExecutor()));
        }
    }
}

