/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal.operation;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.db.commons.shaded.AbstractDbConnector;
import org.mule.db.commons.shaded.api.param.BulkQueryDefinition;
import org.mule.db.commons.shaded.api.param.BulkScript;
import org.mule.db.commons.shaded.api.param.ParameterizedStatementDefinition;
import org.mule.db.commons.shaded.api.param.QuerySettings;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.db.commons.shaded.internal.domain.executor.BulkExecutor;
import org.mule.db.commons.shaded.internal.domain.executor.BulkUpdateExecutor;
import org.mule.db.commons.shaded.internal.domain.executor.QueryExecutor;
import org.mule.db.commons.shaded.internal.domain.query.BulkQuery;
import org.mule.db.commons.shaded.internal.domain.query.Query;
import org.mule.db.commons.shaded.internal.domain.query.QueryParamValue;
import org.mule.db.commons.shaded.internal.domain.query.QueryType;
import org.mule.db.commons.shaded.internal.domain.statement.ConfigurableStatementFactory;
import org.mule.db.commons.shaded.internal.operation.BaseDbOperations;
import org.mule.db.commons.shaded.internal.parser.QueryTemplateParser;
import org.mule.db.commons.shaded.internal.parser.SimpleQueryTemplateParser;
import org.mule.db.commons.shaded.internal.resolver.query.BulkQueryFactory;
import org.mule.db.commons.shaded.internal.resolver.query.BulkQueryResolver;
import org.mule.db.commons.shaded.internal.resolver.query.DefaultBulkQueryFactory;
import org.mule.db.commons.shaded.internal.resolver.query.FileBulkQueryFactory;
import org.mule.db.commons.shaded.internal.resolver.query.QueryResolver;
import org.mule.db.commons.shaded.internal.util.DefaultFileReader;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public class BulkOperations
extends BaseDbOperations {
    protected BulkQueryResolver bulkQueryResolver;
    protected QueryTemplateParser queryTemplateParser;
    protected Function<ConfigurableStatementFactory, BulkExecutor> bulkExecutorSupplier;

    private BulkOperations(QueryResolver<ParameterizedStatementDefinition> queryResolver, ConfigurableStatementFactory statementFactory, BulkQueryResolver bulkQueryResolver, QueryTemplateParser queryTemplateParser, Function<ConfigurableStatementFactory, BulkExecutor> bulkExecutor, Function<ConfigurableStatementFactory, QueryExecutor> updateExecutor) {
        super(queryResolver, statementFactory, updateExecutor);
        this.bulkQueryResolver = bulkQueryResolver;
        this.queryTemplateParser = queryTemplateParser;
        this.bulkExecutorSupplier = bulkExecutor;
    }

    protected static BulkQueryResolver getDefaultBulkQueryResolver() {
        return new BulkQueryResolver();
    }

    protected static QueryTemplateParser getDefaultQueryTemplateParser() {
        return new SimpleQueryTemplateParser();
    }

    protected static Function<ConfigurableStatementFactory, BulkExecutor> getDefaultBulkExecutor() {
        return BulkUpdateExecutor::new;
    }

    public int[] bulkInsert(List<Map<String, Object>> bulkInputParameters, BulkQueryDefinition query, AbstractDbConnector connector, DbConnection connection, StreamingHelper streamingHelper) throws SQLException {
        return this.singleQueryBulk(query, bulkInputParameters, connector, connection, streamingHelper, QueryType.INSERT);
    }

    public int[] bulkUpdate(List<Map<String, Object>> bulkInputParameters, BulkQueryDefinition query, AbstractDbConnector connector, DbConnection connection, StreamingHelper streamingHelper) throws SQLException {
        return this.singleQueryBulk(query, bulkInputParameters, connector, connection, streamingHelper, QueryType.UPDATE, QueryType.TRUNCATE, QueryType.MERGE, QueryType.STORE_PROCEDURE_CALL);
    }

    public int[] bulkDelete(List<Map<String, Object>> bulkInputParameters, BulkQueryDefinition query, AbstractDbConnector connector, DbConnection connection, StreamingHelper streamingHelper) throws SQLException {
        return this.singleQueryBulk(query, bulkInputParameters, connector, connection, streamingHelper, QueryType.DELETE);
    }

    public int[] executeScript(BulkScript script, QuerySettings settings, DbConnection connection) throws SQLException {
        BulkQueryFactory bulkQueryFactory = !StringUtils.isEmpty((CharSequence)script.getFile()) ? new FileBulkQueryFactory(script.getFile(), this.queryTemplateParser, new DefaultFileReader()) : new DefaultBulkQueryFactory(this.queryTemplateParser, script.getSql());
        BulkQuery bulkQuery = bulkQueryFactory.resolve();
        BulkExecutor bulkExecutor = this.bulkExecutorSupplier.apply(this.getStatementFactory(settings));
        return (int[])bulkExecutor.execute(connection, bulkQuery);
    }

    private int[] singleQueryBulk(BulkQueryDefinition query, List<Map<String, Object>> values, AbstractDbConnector connector, DbConnection connection, StreamingHelper streamingHelper, QueryType ... queryType) throws SQLException {
        Query resolvedQuery = this.resolveQuery(query, connector, connection, streamingHelper, queryType);
        List<List<QueryParamValue>> paramSets = this.resolveParamSets(values);
        BulkExecutor bulkExecutor = this.bulkExecutorSupplier.apply(this.getStatementFactory(query));
        return (int[])bulkExecutor.execute(connection, resolvedQuery, paramSets);
    }

    protected Query resolveQuery(BulkQueryDefinition query, AbstractDbConnector connector, DbConnection connection, StreamingHelper streamingHelper, QueryType ... validTypes) {
        Query resolvedQuery = this.bulkQueryResolver.resolve(query, connector, connection, streamingHelper);
        this.validateQueryType(resolvedQuery.getQueryTemplate(), Arrays.asList(validTypes));
        this.validateNoParameterTypeIsUnused(resolvedQuery, query.getParameterTypes());
        return resolvedQuery;
    }

    private List<List<QueryParamValue>> resolveParamSets(List<Map<String, Object>> values) {
        ArrayList<List<QueryParamValue>> parameterSet = new ArrayList<List<QueryParamValue>>();
        for (Map<String, Object> value : values) {
            Map map = (Map)TypedValue.unwrap(value);
            parameterSet.add(map.entrySet().stream().map(entry -> new QueryParamValue((String)entry.getKey(), entry.getValue())).collect(Collectors.toList()));
        }
        return parameterSet;
    }

    public static class Builder {
        private Optional<QueryResolver<ParameterizedStatementDefinition>> queryResolverOptional = Optional.empty();
        private Optional<BulkQueryResolver> bulkQueryResolverOptional = Optional.empty();
        private Optional<QueryTemplateParser> queryTemplateParserOptional = Optional.empty();
        private Optional<ConfigurableStatementFactory> statementFactoryOptional = Optional.empty();
        private Optional<Function<ConfigurableStatementFactory, BulkExecutor>> bulkExecutorOptional = Optional.empty();
        private Optional<Function<ConfigurableStatementFactory, QueryExecutor>> updateExecutorOptional = Optional.empty();

        public Builder withQueryResolver(QueryResolver<ParameterizedStatementDefinition> queryResolver) {
            this.queryResolverOptional = Optional.of(queryResolver);
            return this;
        }

        public Builder withBulkQueryResolver(BulkQueryResolver bulkQueryResolver) {
            this.bulkQueryResolverOptional = Optional.of(bulkQueryResolver);
            return this;
        }

        public Builder withQueryParser(QueryTemplateParser queryTemplateParser) {
            this.queryTemplateParserOptional = Optional.of(queryTemplateParser);
            return this;
        }

        public Builder withStatementFactory(ConfigurableStatementFactory statementFactory) {
            this.statementFactoryOptional = Optional.of(statementFactory);
            return this;
        }

        public Builder withBulkUpdateExecutor(Function<ConfigurableStatementFactory, BulkExecutor> bulkExecutor) {
            this.bulkExecutorOptional = Optional.of(bulkExecutor);
            return this;
        }

        public Builder withUpdateExecutor(Function<ConfigurableStatementFactory, QueryExecutor> updateExecutor) {
            this.updateExecutorOptional = Optional.of(updateExecutor);
            return this;
        }

        public BulkOperations build() {
            return new BulkOperations(this.queryResolverOptional.orElse(BaseDbOperations.getDefaultQueryResolver()), this.statementFactoryOptional.orElse(BaseDbOperations.getDefaultStatementFactory()), this.bulkQueryResolverOptional.orElse(BulkOperations.getDefaultBulkQueryResolver()), this.queryTemplateParserOptional.orElse(BulkOperations.getDefaultQueryTemplateParser()), this.bulkExecutorOptional.orElse(BulkOperations.getDefaultBulkExecutor()), this.updateExecutorOptional.orElse(BaseDbOperations.getDefaultUpdateExecutor()));
        }
    }
}

