/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal.domain.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.mule.db.commons.shaded.api.DbAggregate;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.db.commons.shaded.internal.domain.type.AbstractDbType;
import org.mule.db.commons.shaded.internal.domain.type.DbType;

public class UnknownDbType
extends AbstractDbType {
    public static final String UNKNOWN_TYPE_NAME = "UNKNOWN";
    private static final UnknownDbType instance = new UnknownDbType();

    private UnknownDbType() {
        super(1111, UNKNOWN_TYPE_NAME);
    }

    @Override
    public void setParameterValue(PreparedStatement statement, int index, Object value, DbConnection connection) throws SQLException {
        value = UnknownDbType.createArraysAndStructs(value, connection);
        statement.setObject(index, value);
    }

    static Object createArraysAndStructs(Object value, DbConnection connection) throws SQLException {
        if (value instanceof DbAggregate) {
            DbAggregate dbArray = (DbAggregate)value;
            Object[] arr = UnknownDbType.createArraysAndStructsInner(dbArray.getElements(), connection);
            switch (dbArray.getKind()) {
                case ARRAY: {
                    return connection.createArray(dbArray.getTypeName(), arr);
                }
                case STRUCT: {
                    return connection.createStruct(dbArray.getTypeName(), arr);
                }
            }
            throw new RuntimeException("Unknown kind of DbAggregate: " + (Object)((Object)dbArray.getKind()));
        }
        if (value instanceof List) {
            return UnknownDbType.createArraysAndStructsInner((List)value, connection);
        }
        if (value instanceof Object[]) {
            return UnknownDbType.createArraysAndStructsInner(Arrays.asList((Object[])value), connection);
        }
        return value;
    }

    static Object[] createArraysAndStructsInner(List<?> elements, DbConnection connection) throws SQLException {
        Object[] returnedElements = new Object[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            returnedElements[i] = UnknownDbType.createArraysAndStructs(elements.get(i), connection);
        }
        return returnedElements;
    }

    @Override
    public Object getParameterValue(CallableStatement statement, int index) throws SQLException {
        return statement.getObject(index);
    }

    public static DbType getInstance() {
        return instance;
    }
}

