/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal.domain.type;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Arrays;
import java.util.List;
import org.mule.db.commons.shaded.api.DbAggregate;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.db.commons.shaded.internal.domain.type.AbstractStructuredDbType;
import org.mule.db.commons.shaded.internal.domain.type.UnknownDbType;

public class StructDbType
extends AbstractStructuredDbType {
    public StructDbType(int id, String name) {
        super(id, name);
    }

    @Override
    public void setParameterValue(PreparedStatement statement, int index, Object value, DbConnection dbConnection) throws SQLException {
        if (value != null && !(value instanceof Struct)) {
            Connection connection = statement.getConnection();
            if (value instanceof Object[]) {
                value = connection.createStruct(this.name, UnknownDbType.createArraysAndStructsInner(Arrays.asList((Object[])value), dbConnection));
            } else if (value instanceof DbAggregate) {
                value = UnknownDbType.createArraysAndStructs(value, dbConnection);
            } else if (value instanceof List) {
                value = connection.createStruct(this.name, UnknownDbType.createArraysAndStructsInner((List)value, dbConnection));
            }
        }
        super.setParameterValue(statement, index, value, dbConnection);
    }
}

