/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal.domain.type;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.db.commons.shaded.internal.domain.type.AbstractDbType;
import org.mule.db.commons.shaded.internal.domain.type.UnknownDbType;

public class ResolvedDbType
extends AbstractDbType {
    private static final int ORACLE_TIMESTAMPLTZ_ID = -102;
    private static final String ORACLE_JDBC_PREFIX = "oracle";
    private boolean statementIsComplete;

    public ResolvedDbType(int id, String name) {
        super(id, name);
    }

    @Override
    public void setParameterValue(PreparedStatement statement, int index, Object value, DbConnection connection) throws SQLException {
        if (value == null) {
            statement.setNull(index, this.id);
            return;
        }
        value = UnknownDbType.createArraysAndStructs(value, connection);
        this.statementIsComplete = false;
        if (this.isValidDriverName(statement) && statement.getConnection().getMetaData().getDriverName().toLowerCase().contains(ORACLE_JDBC_PREFIX.toLowerCase())) {
            this.oracleResolveParameterValue(statement, index, value);
        }
        if (!this.statementIsComplete) {
            if (3 == this.id || 2 == this.id) {
                if (value instanceof BigDecimal) {
                    statement.setObject(index, value, this.id, ((BigDecimal)value).scale());
                } else if (value instanceof Float || value instanceof Double) {
                    BigDecimal bigDecimal = new BigDecimal(value.toString());
                    statement.setObject(index, (Object)bigDecimal, this.id, bigDecimal.scale());
                } else if (value instanceof String) {
                    BigDecimal bigDecimal = new BigDecimal((String)value);
                    statement.setObject(index, (Object)bigDecimal, this.id, bigDecimal.scale());
                } else {
                    statement.setObject(index, value, this.id);
                }
            } else {
                statement.setObject(index, value, this.id);
            }
        }
    }

    @Override
    public Object getParameterValue(CallableStatement statement, int index) throws SQLException {
        return statement.getObject(index);
    }

    private void oracleResolveParameterValue(PreparedStatement statement, int index, Object value) throws SQLException {
        if (this.id == -102 || this.id == 91 || this.id == 93) {
            statement.setObject(index, value);
            this.statementIsComplete = true;
        }
    }

    private boolean isValidDriverName(PreparedStatement statement) throws SQLException {
        return statement != null && statement.getConnection() != null && statement.getConnection().getMetaData() != null && statement.getConnection().getMetaData().getDriverName() != null;
    }
}

