/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal.domain.type;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.mule.db.commons.shaded.api.param.JdbcType;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.db.commons.shaded.internal.domain.type.BlobDbType;
import org.mule.db.commons.shaded.internal.domain.type.ClobResolvedDataType;
import org.mule.db.commons.shaded.internal.domain.type.DbType;
import org.mule.db.commons.shaded.internal.domain.type.DbTypeManager;
import org.mule.db.commons.shaded.internal.domain.type.ResolvedDbType;
import org.mule.db.commons.shaded.internal.domain.type.StructDbType;
import org.mule.db.commons.shaded.internal.domain.type.UnknownDbType;
import org.mule.db.commons.shaded.internal.domain.type.UnknownDbTypeException;
import org.mule.db.commons.shaded.internal.result.resultset.ResultSetIterator;
import org.mule.db.commons.shaded.internal.result.row.InsensitiveMapRowHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataDbTypeManager
implements DbTypeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataDbTypeManager.class);
    static final String METADATA_TYPE_ID_COLUMN = "DATA_TYPE";
    static final String METADATA_TYPE_NAME_COLUMN = "TYPE_NAME";
    private final Map<String, DbType> typesById = new HashMap<String, DbType>();
    private final Object lock = new Object();
    private boolean initialised;

    protected void registerType(DbType dbType) {
        String typeKey = dbType.getName() + dbType.getId();
        if (this.typesById.containsKey(typeKey)) {
            LOGGER.warn(String.format("There is already a registered type with ID %s and name %s", dbType.getId(), dbType.getName()));
        } else {
            this.typesById.put(typeKey, dbType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbType lookup(DbConnection connection, int id, String name) throws UnknownDbTypeException {
        String typeKey;
        if (!this.initialised) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.initialised) {
                    this.initialise(connection);
                    this.initialised = true;
                }
            }
        }
        if (this.typesById.containsKey(typeKey = name + id)) {
            return this.typesById.get(typeKey);
        }
        if (id == 1111) {
            return UnknownDbType.getInstance();
        }
        throw new UnknownDbTypeException(id, name);
    }

    @Override
    public DbType lookup(DbConnection connection, String name) throws UnknownDbTypeException {
        throw new UnknownDbTypeException(name);
    }

    protected void initialise(DbConnection connection) {
        try {
            DatabaseMetaData metaData = connection.getJdbcConnection().getMetaData();
            ResultSet typeInfo = metaData.getTypeInfo();
            ResultSetIterator resultSetIterator = new ResultSetIterator(typeInfo, new InsensitiveMapRowHandler(connection));
            while (resultSetIterator.hasNext()) {
                Object typeRecord = resultSetIterator.next();
                Number dataType = (Number)typeRecord.get(METADATA_TYPE_ID_COLUMN);
                String typeName = (String)typeRecord.get(METADATA_TYPE_NAME_COLUMN);
                ResolvedDbType resolvedDbType = Objects.equals(2004, dataType.intValue()) ? new BlobDbType(dataType.intValue(), typeName) : (Objects.equals(2005, dataType.intValue()) || Objects.equals(2011, dataType.intValue()) ? new ClobResolvedDataType(dataType.intValue(), typeName) : (Objects.equals(2002, dataType.intValue()) ? new StructDbType(dataType.intValue(), typeName) : new ResolvedDbType(dataType.intValue(), typeName)));
                if (this.isUserDefinedType(resolvedDbType)) continue;
                this.registerType(resolvedDbType);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Type: " + typeRecord);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Cannot process metadata information", e);
        }
    }

    private boolean isUserDefinedType(DbType dbType) {
        return MetadataDbTypeManager.isTypeDerivedFrom(dbType, JdbcType.STRUCT.getDbType()) || MetadataDbTypeManager.isTypeDerivedFrom(dbType, JdbcType.DISTINCT.getDbType()) || MetadataDbTypeManager.isTypeDerivedFrom(dbType, JdbcType.ARRAY.getDbType());
    }

    public static boolean isTypeDerivedFrom(DbType type, DbType baseType) {
        return type.getId() == baseType.getId() && !type.getName().equals(baseType.getName());
    }
}

