/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal.domain.executor;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.mule.db.commons.shaded.api.StatementResult;
import org.mule.db.commons.shaded.internal.domain.autogeneratedkey.AutoGenerateKeysStrategy;
import org.mule.db.commons.shaded.internal.domain.autogeneratedkey.NoAutoGenerateKeysStrategy;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.db.commons.shaded.internal.domain.executor.AbstractSingleQueryExecutor;
import org.mule.db.commons.shaded.internal.domain.query.Query;
import org.mule.db.commons.shaded.internal.domain.statement.StatementFactory;
import org.mule.db.commons.shaded.internal.result.resultset.ListResultSetHandler;
import org.mule.db.commons.shaded.internal.result.row.InsensitiveMapRowHandler;

public class UpdateExecutor
extends AbstractSingleQueryExecutor {
    public UpdateExecutor(StatementFactory statementFactory) {
        super(statementFactory);
    }

    @Override
    protected Object doExecuteQuery(DbConnection connection, Statement statement, Query query) throws SQLException {
        return this.doExecuteQuery(connection, statement, query, new NoAutoGenerateKeysStrategy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doExecuteQuery(DbConnection dbConnection, Statement statement, Query query, AutoGenerateKeysStrategy autoGenerateKeysStrategy) throws SQLException {
        try {
            StatementResult result;
            int updateCount = autoGenerateKeysStrategy.executeUpdate(statement, query.getQueryTemplate());
            if (autoGenerateKeysStrategy.returnsAutoGenerateKeys()) {
                ListResultSetHandler listResultSetHandler = new ListResultSetHandler(new InsensitiveMapRowHandler(dbConnection));
                ResultSet generatedKeys = statement.getGeneratedKeys();
                Object generatedKeyList = listResultSetHandler.processResultSet(dbConnection, generatedKeys);
                Map keyMap = generatedKeyList.isEmpty() ? null : (Map)generatedKeyList.get(0);
                result = new StatementResult(updateCount, keyMap);
            } else {
                result = new StatementResult(updateCount, null);
            }
            StatementResult statementResult = result;
            return statementResult;
        }
        finally {
            statement.close();
        }
    }
}

