/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal.domain.executor;

import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.mule.db.commons.shaded.api.exception.connection.QueryExecutionException;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.db.commons.shaded.internal.domain.executor.AbstractExecutor;
import org.mule.db.commons.shaded.internal.domain.executor.BulkExecutor;
import org.mule.db.commons.shaded.internal.domain.logger.BulkQueryLogger;
import org.mule.db.commons.shaded.internal.domain.logger.PreparedBulkQueryLogger;
import org.mule.db.commons.shaded.internal.domain.query.BulkQuery;
import org.mule.db.commons.shaded.internal.domain.query.Query;
import org.mule.db.commons.shaded.internal.domain.query.QueryParamValue;
import org.mule.db.commons.shaded.internal.domain.query.QueryTemplate;
import org.mule.db.commons.shaded.internal.domain.statement.StatementFactory;

public class BulkUpdateExecutor
extends AbstractExecutor
implements BulkExecutor {
    public BulkUpdateExecutor(StatementFactory statementFactory) {
        super(statementFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(DbConnection connection, BulkQuery bulkQuery) throws SQLException {
        Statement statement = this.statementFactory.create(connection, bulkQuery.getQueryTemplates().get(0));
        try {
            BulkQueryLogger queryLogger = this.queryLoggerFactory.createBulkQueryLogger(LOGGER);
            for (QueryTemplate queryTemplate : bulkQuery.getQueryTemplates()) {
                String sql = queryTemplate.getSqlText();
                statement.addBatch(sql);
                queryLogger.addQuery(sql);
            }
            queryLogger.logQuery();
            Object object = statement.executeBatch();
            return object;
        }
        finally {
            statement.clearBatch();
            statement.close();
        }
    }

    @Override
    public Object execute(DbConnection connection, Query query, List<List<QueryParamValue>> paramValues) throws SQLException {
        Statement statement = this.statementFactory.create(connection, query.getQueryTemplate());
        int batchCount = 0;
        if (!(statement instanceof PreparedStatement)) {
            throw new QueryExecutionException("The given query can't be executed in bulk, bulk queries must take parameters.");
        }
        PreparedStatement preparedStatement = (PreparedStatement)statement;
        PreparedBulkQueryLogger queryLogger = this.queryLoggerFactory.createBulkQueryLogger(LOGGER, query.getQueryTemplate(), paramValues.size());
        try {
            for (List<QueryParamValue> list : paramValues) {
                this.doProcessParameters(preparedStatement, query.getQueryTemplate(), list, queryLogger, connection);
                preparedStatement.addBatch();
                queryLogger.addParameterSet();
                ++batchCount;
            }
            queryLogger.logQuery();
            int[] result = preparedStatement.executeBatch();
            this.logBulkUpdateInfo(result, batchCount);
            int[] nArray = result;
            return nArray;
        }
        catch (BatchUpdateException batchEx) {
            int[] nArray = batchEx.getUpdateCounts();
            this.logBulkUpdateInfo(nArray, batchCount);
            throw new SQLException(batchEx);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        finally {
            preparedStatement.clearParameters();
            statement.close();
        }
    }

    private void logBulkUpdateInfo(int[] updateCounts, int batchCount) {
        int successfulOperations = 0;
        int failedOperations = 0;
        int noInfoAvailable = 0;
        for (int i = 0; i < updateCounts.length; ++i) {
            if (updateCounts[i] >= 0) {
                ++successfulOperations;
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("BULK OPERATION {} SUCCESSFULLY PERFORMED: {} AFFECTED ROWS", (Object)i, (Object)updateCounts[i]);
                continue;
            }
            if (updateCounts[i] == -2) {
                ++noInfoAvailable;
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("BULK OPERATION {} PERFORMED SUCCESSFULLY: NO INFO AVAILABLE ON AFFECTED ROW COUNT", (Object)i);
                continue;
            }
            if (updateCounts[i] != -3) continue;
            ++failedOperations;
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("BULK OPERATION {} FAILED: {} AFFECTED ROWS.", (Object)i, (Object)updateCounts[i]);
        }
        if (failedOperations > 0) {
            LOGGER.error("BULK UPDATE EXCEPTION: {} SUCCESSFUL OPERATIONS, {} FAILED OPERATIONS.", (Object)(successfulOperations + noInfoAvailable), (Object)failedOperations);
        } else if (updateCounts.length < batchCount) {
            LOGGER.error("BULK UPDATE EXCEPTION. DATABASE PROCESSED {} OPERATIONS SUCCESSFULLY AND STOPPED PROCESSING DUE TO EXCEPTION.", (Object)(successfulOperations + noInfoAvailable));
        } else {
            LOGGER.debug("SUCCESSFULLY EXECUTED BATCH OPERATION. TOTAL EXECUTED STATEMENTS: {}.", (Object)batchCount);
        }
    }
}

