/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal.domain.connection.enhydra.wrappers;

import java.util.Properties;
import org.mule.runtime.api.tls.TlsContextFactory;

public final class EnhydraWrapperUtils {
    private static final String SSL_KEYSTORE = "javax.net.ssl.keyStore";
    private static final String SSL_KEYSTORE_TYPE = "javax.net.ssl.keyStoreType";
    private static final String SSL_KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static final String SSL_TRUSTSTORE = "javax.net.ssl.trustStore";
    private static final String SSL_TRUSTSTORE_TYPE = "javax.net.ssl.trustStoreType";
    private static final String SSL_TRUSTSTORE_PASSWORD = "javax.net.ssl.trustStorePassword";

    private EnhydraWrapperUtils() {
    }

    public static void setTLSProperties(Properties prop, TlsContextFactory tlsContextFactory) {
        if (tlsContextFactory == null) {
            return;
        }
        if (tlsContextFactory.isKeyStoreConfigured()) {
            if (!tlsContextFactory.getKeyStoreConfiguration().getPath().isEmpty()) {
                prop.put(SSL_KEYSTORE, tlsContextFactory.getKeyStoreConfiguration().getPath());
            }
            if (!tlsContextFactory.getKeyStoreConfiguration().getType().isEmpty()) {
                prop.put(SSL_KEYSTORE_TYPE, tlsContextFactory.getKeyStoreConfiguration().getType());
            }
            if (!tlsContextFactory.getKeyStoreConfiguration().getPassword().isEmpty()) {
                prop.put(SSL_KEYSTORE_PASSWORD, tlsContextFactory.getKeyStoreConfiguration().getPassword());
            }
        }
        if (tlsContextFactory.isTrustStoreConfigured()) {
            if (!tlsContextFactory.getTrustStoreConfiguration().getPath().isEmpty()) {
                prop.put(SSL_TRUSTSTORE, tlsContextFactory.getTrustStoreConfiguration().getPath());
            }
            if (!tlsContextFactory.getTrustStoreConfiguration().getType().isEmpty()) {
                prop.put(SSL_TRUSTSTORE_TYPE, tlsContextFactory.getTrustStoreConfiguration().getType());
            }
            if (!tlsContextFactory.getTrustStoreConfiguration().getPassword().isEmpty()) {
                prop.put(SSL_TRUSTSTORE_PASSWORD, tlsContextFactory.getTrustStoreConfiguration().getPassword());
            }
        }
    }
}

