/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal.domain.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.sql.DataSource;
import org.mule.db.commons.shaded.api.exception.connection.ConnectionCreationException;
import org.mule.db.commons.shaded.internal.domain.type.DbType;
import org.mule.db.commons.shaded.internal.domain.type.MappedStructResolvedDbType;
import org.mule.db.commons.shaded.internal.util.CredentialsMaskUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcConnectionFactory {
    private final Function<String, String> maskCredentialsFunction;
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcConnectionFactory.class);

    protected JdbcConnectionFactory(Builder builder) {
        this.maskCredentialsFunction = (Function)builder.maskCredentialsFunctionOptional.get();
    }

    public Connection createConnection(DataSource dataSource, List<DbType> customDataTypes) throws SQLException, ConnectionCreationException {
        try {
            Connection connection = dataSource.getConnection();
            if (connection == null) {
                throw new ConnectionCreationException("Unable to create connection to the provided dataSource: " + dataSource);
            }
            Map<String, Class<?>> typeMapping = this.createTypeMapping(customDataTypes);
            if (!typeMapping.isEmpty()) {
                connection.setTypeMap(typeMapping);
            }
            return connection;
        }
        catch (SQLException e) {
            String maskedMessage = this.maskCredentialsFunction.apply(e.getMessage());
            LOGGER.error(String.format("Error while creating connection:\n Message: '%s', \n SQLState: '%s'; \n ErrorCode: '%s';\n", maskedMessage, e.getSQLState(), e.getErrorCode()), (Throwable)e);
            throw new SQLException(maskedMessage, e.getSQLState(), e.getErrorCode(), e.getCause());
        }
    }

    private Map<String, Class<?>> createTypeMapping(List<DbType> customDataTypes) {
        HashMap typeMapping = new HashMap();
        customDataTypes.stream().filter(dbType -> dbType instanceof MappedStructResolvedDbType).forEach(dbType -> {
            MappedStructResolvedDbType structDbType = (MappedStructResolvedDbType)dbType;
            if (structDbType.getMappedClass() != null) {
                typeMapping.put(structDbType.getName(), structDbType.getMappedClass());
            }
        });
        return typeMapping;
    }

    public static class Builder {
        private Optional<Function<String, String>> maskCredentialsFunctionOptional = Optional.empty();

        public Builder withMaskCredentialsFunction(Function<String, String> maskCredentialsFunction) {
            this.maskCredentialsFunctionOptional = Optional.of(maskCredentialsFunction);
            return this;
        }

        public JdbcConnectionFactory build() {
            if (!this.maskCredentialsFunctionOptional.isPresent()) {
                this.maskCredentialsFunctionOptional = Optional.of(CredentialsMaskUtils::maskUrlUserAndPassword);
            }
            return new JdbcConnectionFactory(this);
        }
    }
}

