/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementStreamingResultSetCloser {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatementStreamingResultSetCloser.class);
    private final DbConnection connection;
    private final Set<ResultSet> resultSets = Collections.newSetFromMap(new ConcurrentHashMap());

    public StatementStreamingResultSetCloser(DbConnection connection) {
        this.connection = connection;
    }

    public void closeResultSets() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing {} resultSets", (Object)this.getOpenResultSets());
        }
        try {
            for (ResultSet resultSet : this.resultSets) {
                this.close(resultSet);
            }
        }
        finally {
            for (int i = 0; i < this.resultSets.size(); ++i) {
                this.connection.endStreaming();
            }
            this.resultSets.clear();
            if (!this.connection.isTransactionActive()) {
                this.connection.release();
            }
        }
    }

    private void close(ResultSet resultSet) {
        try {
            if (!resultSet.isClosed()) {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            LOGGER.warn("Error attempting to close resultSet", (Throwable)e);
        }
    }

    public void trackResultSet(ResultSet resultSet) {
        this.resultSets.add(resultSet);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ResultSet opened, now {} active", (Object)this.getOpenResultSets());
        }
    }

    public int getOpenResultSets() {
        return this.resultSets.size();
    }
}

