/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal;

import java.util.List;
import javax.inject.Inject;
import org.mule.db.commons.shaded.api.DbAggregate;
import org.mule.db.commons.shaded.internal.DbFunctionUtil;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.extension.ExtensionManager;

public class DbFunctions
implements Initialisable {
    @Inject
    ExtensionManager extensionManager;
    DbFunctionUtil util = null;

    public Object createArray(String configName, String typeName, List<Object> values) {
        try {
            return this.util.execute(con -> con.createArray(typeName, values.toArray()), configName);
        }
        catch (Throwable t) {
            throw new RuntimeException("An error occurred when trying to create SQL array \"" + typeName + "\":  " + t, t);
        }
    }

    public Object prepareArray(String typeName, List<Object> values) {
        return new DbAggregate(DbAggregate.Kind.ARRAY, typeName, values);
    }

    public Object createStruct(String configName, String typeName, List<Object> properties) {
        try {
            return this.util.execute(con -> con.createStruct(typeName, properties.toArray()), configName);
        }
        catch (Throwable t) {
            throw new RuntimeException("An error occurred when trying to create SQL struct \"" + typeName + "\":  " + t, t);
        }
    }

    public Object prepareStruct(String typeName, List<Object> properties) {
        return new DbAggregate(DbAggregate.Kind.STRUCT, typeName, properties);
    }

    public void initialise() throws InitialisationException {
        this.util = new DbFunctionUtil(this.extensionManager);
    }
}

