/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.shaded.internal;

import java.sql.SQLException;
import java.util.List;
import org.mule.db.commons.shaded.internal.domain.connection.DbConnection;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.exception.NullExceptionHandler;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;

public class DbFunctionUtil {
    private final ExtensionManager extensionManager;
    private static final CoreEvent EVENT = CoreEvent.builder((EventContext)EventContextFactory.create((String)"DB", (String)"dummy", (ComponentLocation)DefaultComponentLocation.fromSingleComponent((String)"DB"), (FlowExceptionHandler)NullExceptionHandler.getInstance())).message(Message.of((Object)"none")).build();

    public DbFunctionUtil(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(ConnectedFunction<T> connectedFunction, String connectionName) throws ConnectionException, SQLException {
        T t;
        block4: {
            ConnectionProvider<T> connectionProvider = this.getConnectionProvider(connectionName);
            DbConnection dbConnection = null;
            try {
                Object connection = connectionProvider.connect();
                if (!(connection instanceof DbConnection)) {
                    throw new ConnectionException("Connection is not a DB Connection");
                }
                dbConnection = (DbConnection)connection;
                t = connectedFunction.apply(dbConnection);
                if (dbConnection == null) break block4;
            }
            catch (Throwable throwable) {
                if (dbConnection != null) {
                    connectionProvider.disconnect(dbConnection);
                }
                throw throwable;
            }
            connectionProvider.disconnect((Object)dbConnection);
        }
        return t;
    }

    private <T> ConnectionProvider<T> getConnectionProvider(String configName) {
        ConfigurationInstance configuration = this.extensionManager.getConfiguration(configName, EVENT);
        return (ConnectionProvider)configuration.getConnectionProvider().orElseThrow(() -> new RuntimeException(String.format("Unable to obtain a connection for configuration: [%s]", configName)));
    }

    @Deprecated
    public Object execute(WithConnection withConnection, List<Object> values, String typeName, String connectionName) {
        try {
            return this.execute(connection -> withConnection.execute(connection, values, typeName), connectionName);
        }
        catch (Throwable t) {
            throw new RuntimeException("An error occurred when trying to create JDBC Structure. " + t.getMessage(), t);
        }
    }

    @Deprecated
    @FunctionalInterface
    public static interface WithConnection {
        public Object execute(DbConnection var1, List<Object> var2, String var3) throws ConnectionException, SQLException;
    }

    @FunctionalInterface
    public static interface ConnectedFunction<T> {
        public T apply(DbConnection var1) throws ConnectionException, SQLException;
    }
}

