/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.util;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.mule.db.commons.api.exception.connection.BadSqlSyntaxException;
import org.mule.runtime.api.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredProcedureUtils {
    private static final String STORED_PROCEDURE_REGEX = "(?msi)(\\{\\s*)?call\\s+([\\[\\]\\w]+\\.)?([\\[\\]\\w]+\\.)?([\\[\\]\\w\\$]+)\\s*\\(.*";
    private static final String FUNCTION_REGEX = "(?msi)(\\{\\?\\s*)?=\\s*call\\s+([\\[\\]\\w]+\\.)?([\\[\\]\\w]+\\.)?([\\[\\]\\w]+)\\s*\\(.*";
    private static final Pattern storedProcedurePattern = Pattern.compile("(?msi)(\\{\\s*)?call\\s+([\\[\\]\\w]+\\.)?([\\[\\]\\w]+\\.)?([\\[\\]\\w\\$]+)\\s*\\(.*");
    private static final Pattern functionPattern = Pattern.compile("(?msi)(\\{\\?\\s*)?=\\s*call\\s+([\\[\\]\\w]+\\.)?([\\[\\]\\w]+\\.)?([\\[\\]\\w]+)\\s*\\(.*");
    private static final Logger LOGGER = LoggerFactory.getLogger(StoredProcedureUtils.class);

    public static Pair<String, Boolean> analyzeStoredOperation(String sqlText) throws BadSqlSyntaxException {
        Pair<Matcher, Boolean> result = StoredProcedureUtils.analyzeSqlText(sqlText, "name");
        return new Pair((Object)((Matcher)result.getFirst()).group(4), result.getSecond());
    }

    public static Optional<String> getStoreProcedureOwner(String sqlText) throws BadSqlSyntaxException {
        Matcher matcher = (Matcher)StoredProcedureUtils.analyzeSqlText(sqlText, "schema").getFirst();
        String firstPart = matcher.group(2);
        String secondPart = matcher.group(3);
        if (!StringUtils.isBlank((CharSequence)firstPart) && !StringUtils.isBlank((CharSequence)secondPart)) {
            String packageName = firstPart.substring(0, firstPart.length() - 1);
            return Optional.of(packageName);
        }
        if (!StringUtils.isBlank((CharSequence)firstPart)) {
            String packageName = firstPart.substring(0, firstPart.length() - 1);
            return Optional.of(packageName);
        }
        if (!StringUtils.isBlank((CharSequence)secondPart)) {
            String packageName = secondPart.substring(0, secondPart.length() - 1);
            return Optional.of(packageName);
        }
        return Optional.empty();
    }

    public static Optional<String> getStoredProcedureParentOwner(String sqlText) throws BadSqlSyntaxException {
        Matcher matcher = (Matcher)StoredProcedureUtils.analyzeSqlText(sqlText, "package").getFirst();
        String firstPart = matcher.group(2);
        String secondPart = matcher.group(3);
        if (!StringUtils.isBlank((CharSequence)firstPart) && !StringUtils.isBlank((CharSequence)secondPart)) {
            String packageName = secondPart.substring(0, secondPart.length() - 1);
            return Optional.of(packageName);
        }
        return Optional.empty();
    }

    private static Pair<Matcher, Boolean> analyzeSqlText(String sqlText, String stage) throws BadSqlSyntaxException {
        boolean isFunction = false;
        Matcher matcher = storedProcedurePattern.matcher(sqlText);
        if (!matcher.matches()) {
            String exception = String.format("Unable to detect stored procedure '%s' from '%s'. Looking for function '%s'.", stage, sqlText, stage);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(exception);
            }
            if (!(matcher = functionPattern.matcher(sqlText)).matches()) {
                exception = String.format("Unable to detect function '%s' from '%s'.", stage, sqlText);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(exception);
                }
                throw new BadSqlSyntaxException(exception);
            }
            isFunction = true;
        }
        return new Pair((Object)matcher, (Object)isFunction);
    }
}

