/*
 * Decompiled with CFR 0.152.
 */
package org.mule.oauth.client.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.mule.oauth.client.api.ClientCredentialsOAuthDancer;
import org.mule.oauth.client.api.exception.RequestAuthenticationException;
import org.mule.oauth.client.api.exception.TokenNotFoundException;
import org.mule.oauth.client.api.exception.TokenUrlResponseException;
import org.mule.oauth.client.api.listener.ClientCredentialsListener;
import org.mule.oauth.client.api.listener.OAuthStateListener;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContextWithRefreshState;
import org.mule.oauth.client.internal.AbstractOAuthDancer;
import org.mule.oauth.client.internal.config.DefaultClientCredentialsOAuthDancerConfig;
import org.mule.oauth.client.internal.util.ClassLoaderUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientCredentialsOAuthDancer
extends AbstractOAuthDancer<DefaultClientCredentialsOAuthDancerConfig>
implements ClientCredentialsOAuthDancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClientCredentialsOAuthDancer.class);
    private boolean accessTokenRefreshedOnStart = false;

    public DefaultClientCredentialsOAuthDancer(DefaultClientCredentialsOAuthDancerConfig config) {
        super(config);
    }

    @Override
    public void start() throws MuleException {
        super.start();
        try {
            this.refreshToken().get();
            this.accessTokenRefreshedOnStart = true;
        }
        catch (ExecutionException e) {
            if (!(e.getCause() instanceof TokenUrlResponseException) && !(e.getCause() instanceof TokenNotFoundException)) {
                super.stop();
                throw new LifecycleException(e.getCause(), (Object)this);
            }
        }
        catch (InterruptedException e) {
            super.stop();
            Thread.currentThread().interrupt();
            throw new LifecycleException((Throwable)e, (Object)this);
        }
    }

    public CompletableFuture<String> accessToken() throws RequestAuthenticationException {
        if (!this.accessTokenRefreshedOnStart) {
            this.accessTokenRefreshedOnStart = true;
            return this.refreshToken().thenApply(v -> this.getContext().getAccessToken());
        }
        String accessToken = this.getContext().getAccessToken();
        if (accessToken == null) {
            LOGGER.info("Previously stored token has been invalidated. Refreshing...");
            return this.doRefreshTokenRequest(false).thenApply(v -> this.getContext().getAccessToken());
        }
        return CompletableFuture.completedFuture(accessToken);
    }

    public CompletableFuture<Void> refreshToken() {
        return this.doRefreshTokenRequest(true);
    }

    private CompletableFuture<Void> doRefreshTokenRequest(boolean notifyListeners) {
        return this.doRefreshToken(() -> this.getContext(), ctx -> this.doRefreshTokenRequest(notifyListeners, (ResourceOwnerOAuthContextWithRefreshState)ctx));
    }

    private CompletableFuture<Void> doRefreshTokenRequest(boolean notifyListeners, ResourceOwnerOAuthContextWithRefreshState defaultUserState) {
        LinkedHashMap<String, String> formData = new LinkedHashMap<String, String>();
        formData.put("grant_type", "client_credentials");
        if (((DefaultClientCredentialsOAuthDancerConfig)this.config).getScopes() != null) {
            formData.put("scope", ((DefaultClientCredentialsOAuthDancerConfig)this.config).getScopes());
        }
        String authorization = this.handleClientCredentials(formData);
        formData.putAll(((DefaultClientCredentialsOAuthDancerConfig)this.config).getCustomBodyParameters());
        return ((CompletableFuture)this.invokeTokenUrl(((DefaultClientCredentialsOAuthDancerConfig)this.config).getTokenUrl(), formData, ((DefaultClientCredentialsOAuthDancerConfig)this.config).getCustomParameters(), ((DefaultClientCredentialsOAuthDancerConfig)this.config).getCustomHeaders(), authorization, false, ((DefaultClientCredentialsOAuthDancerConfig)this.config).getEncoding()).thenAccept(tokenResponse -> {
            Thread thread = Thread.currentThread();
            ClassLoader currentClassLoader = thread.getContextClassLoader();
            ClassLoader contextClassLoader = DefaultClientCredentialsOAuthDancer.class.getClassLoader();
            ClassLoaderUtils.setContextClassLoader(thread, currentClassLoader, contextClassLoader);
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Retrieved access token, refresh token and expires from token url are: %s, %s, %s", new Object[]{tokenResponse.getAccessToken(), tokenResponse.getRefreshToken(), tokenResponse.getExpiresIn()});
                }
                defaultUserState.setAccessToken(tokenResponse.getAccessToken());
                defaultUserState.setExpiresIn(tokenResponse.getExpiresIn());
                for (Map.Entry<String, Object> customResponseParameterEntry : tokenResponse.getCustomResponseParameters().entrySet()) {
                    defaultUserState.getTokenResponseParameters().put(customResponseParameterEntry.getKey(), customResponseParameterEntry.getValue());
                }
                this.updateOAuthContextAfterTokenResponse((ResourceOwnerOAuthContext)defaultUserState);
                if (notifyListeners) {
                    this.forEachListener(l -> l.onTokenRefreshed((ResourceOwnerOAuthContext)defaultUserState));
                }
            }
            finally {
                ClassLoaderUtils.setContextClassLoader(thread, contextClassLoader, currentClassLoader);
            }
        })).exceptionally(this.tokenUrlExceptionHandler((ResourceOwnerOAuthContext)defaultUserState));
    }

    public void addListener(ClientCredentialsListener listener) {
        this.doAddListener((OAuthStateListener)listener);
    }

    public void removeListener(ClientCredentialsListener listener) {
        this.doRemoveListener((OAuthStateListener)listener);
    }

    public void invalidateContext() {
        this.invalidateContext("default");
    }

    public ResourceOwnerOAuthContext getContext() {
        return this.getContextForResourceOwner("default");
    }

    private void forEachListener(Consumer<ClientCredentialsListener> action) {
        this.onEachListener(listener -> action.accept((ClientCredentialsListener)listener));
    }
}

