/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata.parser.json;

import org.mule.common.metadata.parser.json.AbstractType;

public interface JSONType {
    public boolean contains(Object var1);

    public String explain(Object var1);

    public boolean isOptional();

    public boolean isJSONPrimitive();

    public boolean isJSONArray();

    public boolean isJSONObject();

    public boolean isJSONPointer();

    public static class BooleanType
    extends AbstractType {
        @Override
        public boolean contains(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof Boolean) {
                return true;
            }
            try {
                Boolean.parseBoolean(obj.toString());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public String explain(Object obj) {
            if (obj == null) {
                return String.format("REJECT: null value", new Object[0]);
            }
            if (obj instanceof Boolean) {
                return null;
            }
            try {
                Boolean.parseBoolean(obj.toString());
                return null;
            }
            catch (NumberFormatException e) {
                return String.format("REJECT: %s", e.getMessage());
            }
        }

        @Override
        public boolean isJSONPrimitive() {
            return true;
        }

        @Override
        public boolean isJSONArray() {
            return false;
        }

        @Override
        public boolean isJSONObject() {
            return false;
        }

        @Override
        public boolean isJSONPointer() {
            return false;
        }
    }

    public static class NumberType
    extends AbstractType {
        @Override
        public boolean contains(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof Double) {
                return true;
            }
            try {
                Double.parseDouble(obj.toString());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public String explain(Object obj) {
            if (obj == null) {
                return String.format("REJECT: null value", new Object[0]);
            }
            if (obj instanceof Double) {
                return null;
            }
            try {
                Double.parseDouble(obj.toString());
                return null;
            }
            catch (NumberFormatException e) {
                return String.format("REJECT: %s", e.getMessage());
            }
        }

        @Override
        public boolean isJSONPrimitive() {
            return true;
        }

        @Override
        public boolean isJSONArray() {
            return false;
        }

        @Override
        public boolean isJSONObject() {
            return false;
        }

        @Override
        public boolean isJSONPointer() {
            return false;
        }
    }

    public static class DoubleType
    extends AbstractType {
        @Override
        public boolean contains(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof Double) {
                return true;
            }
            try {
                Double.parseDouble(obj.toString());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public String explain(Object obj) {
            if (obj == null) {
                return String.format("REJECT: null value", new Object[0]);
            }
            if (obj instanceof Double) {
                return null;
            }
            try {
                Double.parseDouble(obj.toString());
                return null;
            }
            catch (NumberFormatException e) {
                return String.format("REJECT: %s", e.getMessage());
            }
        }

        @Override
        public boolean isJSONPrimitive() {
            return true;
        }

        @Override
        public boolean isJSONArray() {
            return false;
        }

        @Override
        public boolean isJSONObject() {
            return false;
        }

        @Override
        public boolean isJSONPointer() {
            return false;
        }
    }

    public static class IntegerType
    extends AbstractType {
        @Override
        public boolean contains(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof Integer) {
                return true;
            }
            try {
                Integer.parseInt(obj.toString());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public String explain(Object obj) {
            if (obj == null) {
                return String.format("REJECT: null value", new Object[0]);
            }
            if (obj instanceof Integer) {
                return null;
            }
            try {
                Integer.parseInt(obj.toString());
                return null;
            }
            catch (NumberFormatException e) {
                return String.format("REJECT: %s", e.getMessage());
            }
        }

        @Override
        public boolean isJSONPrimitive() {
            return true;
        }

        @Override
        public boolean isJSONArray() {
            return false;
        }

        @Override
        public boolean isJSONObject() {
            return false;
        }

        @Override
        public boolean isJSONPointer() {
            return false;
        }
    }

    public static class StringType
    extends AbstractType {
        @Override
        public boolean contains(Object obj) {
            return obj != null && obj instanceof String;
        }

        @Override
        public String explain(Object obj) {
            String typeName = "String";
            if (this.contains(obj)) {
                return null;
            }
            if (obj == null) {
                return String.format("REJECT: null value", new Object[0]);
            }
            return String.format("REJECT: \"%s\" has type %s not in %s", String.valueOf(obj), obj.getClass().getSimpleName(), typeName);
        }

        @Override
        public boolean isJSONPrimitive() {
            return true;
        }

        @Override
        public boolean isJSONArray() {
            return false;
        }

        @Override
        public boolean isJSONObject() {
            return false;
        }

        @Override
        public boolean isJSONPointer() {
            return false;
        }
    }

    public static class Empty
    extends AbstractType {
        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public String explain(Object obj) {
            return String.format("REJECT: \"%s\" not in Empty", String.valueOf(obj));
        }

        @Override
        public boolean isJSONPrimitive() {
            return false;
        }

        @Override
        public boolean isJSONArray() {
            return false;
        }

        @Override
        public boolean isJSONObject() {
            return false;
        }

        @Override
        public boolean isJSONPointer() {
            return false;
        }
    }

    public static class Everything
    extends AbstractType {
        @Override
        public boolean contains(Object obj) {
            return obj != null;
        }

        @Override
        public boolean isJSONPrimitive() {
            return true;
        }

        @Override
        public boolean isJSONArray() {
            return false;
        }

        @Override
        public boolean isJSONObject() {
            return false;
        }

        @Override
        public boolean isJSONPointer() {
            return false;
        }
    }
}

