/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata.datatype;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.mule.common.metadata.datatype.DataType;

public class DataTypeFactory {
    private static final MetaDataModelEvaluator<Void> VOID_EVALUATOR = new AssignableMetaDataModelEvaluator<Void>(new Class[]{Void.TYPE, Void.class}, DataType.VOID);
    private static final MetaDataModelEvaluator<Boolean> BOOLEAN_EVALUATOR = new AssignableMetaDataModelEvaluator<Boolean>(new Class[]{Boolean.TYPE, Boolean.class}, DataType.BOOLEAN);
    private static final MetaDataModelEvaluator<String> STRING_EVALUATOR = new AssignableMetaDataModelEvaluator<String>(new Class[]{String.class, Character.TYPE, Character.class, Class.class}, DataType.STRING);
    private static final MetaDataModelEvaluator<Number> NUMBER_EVALUATOR = new AssignableMetaDataModelEvaluator<Number>(new Class[]{Integer.TYPE, Long.TYPE, Short.TYPE, Double.TYPE, Float.TYPE, Number.class}, DataType.NUMBER);
    private static final MetaDataModelEvaluator<Number> INTEGER_EVALUATOR = new AssignableMetaDataModelEvaluator<Number>(new Class[]{Integer.TYPE, Long.TYPE, Short.TYPE, Integer.class}, DataType.INTEGER);
    private static final MetaDataModelEvaluator<Number> DOUBLE_EVALUATOR = new AssignableMetaDataModelEvaluator<Number>(new Class[]{Double.TYPE, Float.TYPE, Double.class}, DataType.DOUBLE);
    private static final MetaDataModelEvaluator<Number> LONG_EVALUATOR = new AssignableMetaDataModelEvaluator<Number>(new Class[]{Long.TYPE, Long.class}, DataType.LONG);
    private static final MetaDataModelEvaluator<Number> DECIMAL_EVALUATOR = new AssignableMetaDataModelEvaluator<Number>(new Class[]{BigDecimal.class, BigInteger.class}, DataType.DECIMAL);
    private static final MetaDataModelEvaluator<Byte> BYTE_EVALUATOR = new AssignableMetaDataModelEvaluator<Byte>(new Class[]{Byte.TYPE, Byte.class}, DataType.BYTE);
    private static final MetaDataModelEvaluator<?> DATE_TIME_EVALUATOR = new AssignableMetaDataModelEvaluator(new Class[]{Calendar.class, XMLGregorianCalendar.class}, DataType.DATE_TIME);
    private static final MetaDataModelEvaluator<?> DATE_EVALUATOR = new AssignableMetaDataModelEvaluator(new Class[]{java.util.Date.class, Date.class}, DataType.DATE);
    private static final MetaDataModelEvaluator<?> STREAM_EVALUATOR = new AssignableMetaDataModelEvaluator(new Class[]{InputStream.class, OutputStream.class, Reader.class, Writer.class}, DataType.STREAM);
    private static final MetaDataModelEvaluator<Enumeration<?>> ENUM_EVALUATOR = new EnumMetaDataModelEvaluator();
    private static final MetaDataModelEvaluator<List<?>> LIST_EVALUATOR = new AssignableMetaDataModelEvaluator(new Class[]{List.class, Set.class, Object[].class}, DataType.LIST);
    private static final MetaDataModelEvaluator<Map<?, ?>> MAP_EVALUATOR = new AssignableMetaDataModelEvaluator(Map.class, DataType.MAP);
    private static final MetaDataModelEvaluator<?> POJO_EVALUATOR = new AssignableMetaDataModelEvaluator<Object>(Object.class, DataType.POJO){

        @Override
        public boolean isEvaluatable(Class<Object> c) {
            return !c.isPrimitive();
        }
    };
    private static final MetaDataModelEvaluator<?>[] evaluators = new MetaDataModelEvaluator[]{VOID_EVALUATOR, BOOLEAN_EVALUATOR, STRING_EVALUATOR, INTEGER_EVALUATOR, DOUBLE_EVALUATOR, LONG_EVALUATOR, DECIMAL_EVALUATOR, NUMBER_EVALUATOR, BYTE_EVALUATOR, DATE_EVALUATOR, DATE_TIME_EVALUATOR, STREAM_EVALUATOR, ENUM_EVALUATOR, LIST_EVALUATOR, MAP_EVALUATOR, POJO_EVALUATOR};
    private static DataTypeFactory instance = new DataTypeFactory();

    private DataTypeFactory() {
    }

    public static DataTypeFactory getInstance() {
        return instance;
    }

    public DataType getDataType(Class<?> clazz) {
        MetaDataModelEvaluator<?> e;
        DataType dataType = null;
        MetaDataModelEvaluator<?>[] arr$ = evaluators;
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (e = arr$[i$]).isEvaluatable(clazz) && (dataType = e.evaluate(clazz)) != null); ++i$) {
        }
        if (dataType == null) {
            throw new RuntimeException("Data Type for class " + clazz.getName() + " could not be found.");
        }
        return dataType;
    }

    private static class EnumMetaDataModelEvaluator
    extends AssignableMetaDataModelEvaluator<Enumeration<?>> {
        public EnumMetaDataModelEvaluator() {
            super(Enumeration.class, DataType.ENUM);
        }

        @Override
        public boolean isEvaluatable(Class<Enumeration<?>> c) {
            return c.isEnum() || super.isEvaluatable(c);
        }
    }

    private static class AssignableMetaDataModelEvaluator<T>
    implements MetaDataModelEvaluator<T> {
        private Class<?>[] parentClasses;
        private DataType dataType;

        public AssignableMetaDataModelEvaluator(Class<?> parentClass, DataType dataType) {
            this(new Class[]{parentClass}, dataType);
        }

        public AssignableMetaDataModelEvaluator(Class<?>[] parentClasses, DataType dataType) {
            this.parentClasses = parentClasses;
            this.dataType = dataType;
        }

        @Override
        public DataType evaluate(Class<T> c) {
            if (this.isEvaluatable(c)) {
                return this.dataType;
            }
            return null;
        }

        @Override
        public boolean isEvaluatable(Class<T> c) {
            for (Class<T> clazz : this.parentClasses) {
                if (!clazz.isAssignableFrom(c)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static interface MetaDataModelEvaluator<T> {
        public boolean isEvaluatable(Class<T> var1);

        public DataType evaluate(Class<T> var1);
    }
}

