/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.mule.common.metadata.AbstractMetaDataModel;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.DefaultStructuredMetadataModel;
import org.mule.common.metadata.JSONSampleMetaDataFieldFactory;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.datatype.DataType;

public final class JSONMetaDataHelper {
    private JSONMetaDataHelper() {
    }

    public static MetaDataModel buildModelFromNode(JsonNode node) {
        AbstractMetaDataModel result = null;
        if (node.isObject()) {
            JSONSampleMetaDataFieldFactory fieldFactory = new JSONSampleMetaDataFieldFactory((ObjectNode)node);
            result = new DefaultStructuredMetadataModel(DataType.JSON, fieldFactory);
        } else {
            JsonNode child;
            result = node.isArray() ? ((child = JSONMetaDataHelper.getFirstChild((ArrayNode)node)) == null ? new DefaultListMetaDataModel(new DefaultSimpleMetaDataModel(DataType.STRING)) : new DefaultListMetaDataModel(JSONMetaDataHelper.buildModelFromNode(child))) : new DefaultSimpleMetaDataModel(JSONMetaDataHelper.getType(node));
        }
        return result;
    }

    public static DataType getType(JsonNode node) {
        if (node.isTextual()) {
            return DataType.STRING;
        }
        if (node.isBoolean()) {
            return DataType.BOOLEAN;
        }
        if (JSONMetaDataHelper.isInteger(node)) {
            return DataType.INTEGER;
        }
        if (JSONMetaDataHelper.isDouble(node)) {
            return DataType.DOUBLE;
        }
        if (node.isObject()) {
            return DataType.JSON;
        }
        if (node.isArray()) {
            return DataType.LIST;
        }
        if (node.isNull()) {
            return DataType.STRING;
        }
        return DataType.UNKNOWN;
    }

    private static boolean isInteger(JsonNode node) {
        return node.isInt() || node.isBigInteger() || node.isLong() || node.isNumber() || node.isShort();
    }

    private static boolean isDouble(JsonNode node) {
        return node.isDouble() || node.isBigDecimal() || node.isFloat() || node.isFloatingPointNumber();
    }

    public static JsonNode getFirstChild(ArrayNode array) {
        return array.size() > 0 ? array.get(0) : null;
    }
}

